/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.internal.service;

import java.util.Collections;
import java.util.List;
import javax.persistence.criteria.Expression;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.paymentprocessor.exception.PaymentProcessorException;
import org.openvpms.paymentprocessor.internal.i18n.PaymentProcessorMessages;
import org.openvpms.paymentprocessor.service.PaymentProcessorService;
import org.openvpms.plugin.manager.PluginManager;

public class PaymentProcessors {
    private final ArchetypeService service;
    private final PluginManager manager;

    public PaymentProcessors(ArchetypeService service, PluginManager manager) {
        this.manager = manager;
        this.service = service;
    }

    public boolean paymentProcessorServicesExist() {
        return this.manager.hasService(PaymentProcessorService.class);
    }

    public List<Entity> getPaymentProcessors() {
        List result = Collections.emptyList();
        List archetypes = this.service.getArchetypes("entity.paymentProcessor*", false);
        if (!archetypes.isEmpty()) {
            CriteriaBuilder builder = this.service.getCriteriaBuilder();
            CriteriaQuery query = builder.createQuery(Entity.class);
            Root from = query.from(Entity.class, new String[]{"entity.paymentProcessor*"});
            query.where((Expression)builder.equal((Expression)from.get("active"), (Object)true));
            result = this.service.createQuery(query).getResultList();
        }
        return result;
    }

    public PaymentProcessorService getPaymentProcessor(Entity config) {
        PaymentProcessorService result = null;
        List services = this.manager.getServices(PaymentProcessorService.class);
        String archetype = config.getArchetype();
        for (PaymentProcessorService service : services) {
            if (!archetype.equals(service.getArchetype())) continue;
            result = service;
            break;
        }
        if (result == null) {
            throw new PaymentProcessorException(PaymentProcessorMessages.serviceUnavailable(config.getName()));
        }
        return result;
    }
}

