/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.internal.service;

import org.openvpms.archetype.rules.finance.account.CustomerAccountRules;
import org.openvpms.component.model.act.FinancialAct;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.service.object.DomainObjectService;
import org.openvpms.paymentprocessor.internal.service.PaymentProcessorServiceAdapter;
import org.openvpms.paymentprocessor.internal.service.PaymentProcessors;
import org.openvpms.paymentprocessor.processor.PaymentProcessor;
import org.openvpms.paymentprocessor.service.PaymentProcessorService;
import org.openvpms.paymentprocessor.transaction.Transaction;

public class PaymentProcessorTransactionChecker {
    private final PaymentProcessors paymentProcessors;
    private final CustomerAccountRules rules;
    private final DomainObjectService domainService;

    public PaymentProcessorTransactionChecker(PaymentProcessors paymentProcessors, CustomerAccountRules rules, DomainObjectService domainService) {
        this.rules = rules;
        this.paymentProcessors = paymentProcessors;
        this.domainService = domainService;
    }

    public boolean check(FinancialAct act) {
        FinancialAct transactionAct;
        boolean result = false;
        if (!"POSTED".equals(act.getStatus()) && (transactionAct = this.rules.getPaymentProcessorTransaction(act)) != null && "SUBMITTED".equals(transactionAct.getStatus())) {
            Transaction transaction = (Transaction)this.domainService.create((IMObject)transactionAct, Transaction.class);
            PaymentProcessor paymentProcessor = transaction.getPaymentProcessor();
            PaymentProcessorService service = this.paymentProcessors.getPaymentProcessor((Entity)paymentProcessor);
            PaymentProcessorServiceAdapter adapter = new PaymentProcessorServiceAdapter(service);
            result = adapter.check(transaction);
        }
        return result;
    }
}

