/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.paymentprocessor.internal.transaction;

import org.openvpms.archetype.rules.finance.paymentprocessor.PaymentProcessorArchetypes;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.paymentprocessor.transaction.Refund;
import org.openvpms.paymentprocessor.transaction.RefundQuery;

/**
 * Default implementation of {@link RefundQuery}.
 *
 * @author Tim Anderson
 */
public class RefundQueryImpl extends AbstractTransactionQueryImpl<Refund, RefundQuery>
        implements RefundQuery {

    /**
     * Constructs a {@link RefundQueryImpl}.
     *
     * @param service       the service
     * @param domainService the domain service
     */
    public RefundQueryImpl(PaymentProcessorTransactionFactory factory, ArchetypeService service,
                           DomainService domainService) {
        super(Refund.class, factory, service, domainService);
        archetypes(PaymentProcessorArchetypes.REFUND);
    }
}