/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.service;

import org.openvpms.paymentprocessor.processor.TransactionMode;
import org.openvpms.paymentprocessor.service.TransactionCapabilitiesBuilder;
import org.openvpms.paymentprocessor.service.TransactionRequirements;

public class TransactionModeBuilder<T extends TransactionRequirements, B extends TransactionCapabilitiesBuilder<T, B>> {
    private final B parent;
    private final TransactionMode mode;
    private T requirements;

    protected TransactionModeBuilder(B parent, TransactionMode mode) {
        this.parent = parent;
        this.mode = mode;
    }

    public TransactionModeBuilder<T, B> requirements(T requirements) {
        this.requirements = requirements;
        return this;
    }

    public B add() {
        if (this.requirements == null) {
            throw new IllegalStateException("No transaction requirements specified");
        }
        return ((TransactionCapabilitiesBuilder)this.parent).add(new TransactionCapabilitiesBuilder.TransactionModeCapability<T>(this.mode, this.requirements));
    }
}

