/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2024 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.paymentprocessor.service;

/**
 * Payment processor refund capabilities.
 *
 * @author Tim Anderson
 */
public interface RefundCapabilities extends TransactionCapabilities<RefundRequirements> {

    /**
     * Determines if refunds are supported by the payment processor.
     *
     * @return {@code true} if refunds are supported, otherwise {@code false}
     */
    boolean isSupported();

    /**
     * Returns a builder to create capabilities.
     *
     * @return a new builder
     */
    static RefundCapabilitiesBuilder newCapabilities() {
        return new RefundCapabilitiesBuilder();
    }

}
