/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.service;

public class ValidationStatus {
    private final Status status;
    private final String message;

    private ValidationStatus(Status status) {
        this(status, null);
    }

    private ValidationStatus(Status status, String message) {
        this.status = status;
        this.message = message;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public static ValidationStatus valid() {
        return new ValidationStatus(Status.VALID);
    }

    public static ValidationStatus warning(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' must be provided");
        }
        return new ValidationStatus(Status.WARNING, message);
    }

    public static ValidationStatus error(String message) {
        if (message == null) {
            throw new IllegalArgumentException("Argument 'message' must be provided");
        }
        return new ValidationStatus(Status.ERROR, message);
    }

    public static enum Status {
        VALID,
        WARNING,
        ERROR;

    }
}

