/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.service;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.openvpms.paymentprocessor.processor.TransactionMode;
import org.openvpms.paymentprocessor.service.TransactionCapabilities;
import org.openvpms.paymentprocessor.service.TransactionModeBuilder;
import org.openvpms.paymentprocessor.service.TransactionRequirements;

public abstract class TransactionCapabilitiesBuilder<T extends TransactionRequirements, B extends TransactionCapabilitiesBuilder<T, B>> {
    private final Map<TransactionMode, TransactionModeCapability<T>> capabilities = new LinkedHashMap<TransactionMode, TransactionModeCapability<T>>();

    public B add(TransactionMode mode, T requirements) {
        return this.mode(mode).requirements(requirements).add();
    }

    public TransactionModeBuilder<T, B> mode(TransactionMode mode) {
        return new TransactionModeBuilder(this.getThis(), mode);
    }

    public abstract TransactionCapabilities<T> build();

    protected B add(TransactionModeCapability<T> capability) {
        this.capabilities.put(capability.getMode(), capability);
        return this.getThis();
    }

    protected Map<TransactionMode, TransactionModeCapability<T>> getCapabilities() {
        return this.capabilities;
    }

    private B getThis() {
        return (B)this;
    }

    protected static class TransactionModeCapability<T extends TransactionRequirements> {
        private final TransactionMode mode;
        private final T requirements;

        public TransactionModeCapability(TransactionMode mode, T requirements) {
            this.mode = mode;
            this.requirements = requirements;
        }

        public TransactionMode getMode() {
            return this.mode;
        }

        public T getRequirements() {
            return this.requirements;
        }
    }

    protected static class DefaultTransactionCapabilities<T extends TransactionRequirements>
    implements TransactionCapabilities<T> {
        private final Map<TransactionMode, TransactionModeCapability<T>> capabilities;

        public DefaultTransactionCapabilities(Map<TransactionMode, TransactionModeCapability<T>> capabilities) {
            this.capabilities = capabilities;
        }

        @Override
        public Set<TransactionMode> getTransactionModes() {
            return this.capabilities.keySet();
        }

        @Override
        public T getRequirements(TransactionMode mode) {
            TransactionModeCapability<T> capability = this.capabilities.get((Object)mode);
            return capability != null ? (T)capability.getRequirements() : null;
        }
    }
}

