/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.paymentprocessor.transaction;


import org.openvpms.paymentprocessor.exception.PaymentProcessorException;
import org.openvpms.paymentprocessor.transaction.Transaction.Status;

/**
 * Updates the state of a {@link Transaction}.
 *
 * @author Tim Anderson
 */
public interface TransactionUpdater {

    /**
     * Sets the status.
     *
     * @param status the status
     * @return this
     */
    TransactionUpdater status(Status status);

    /**
     * Sets the message.
     *
     * @param message the message
     * @return this
     */
    TransactionUpdater message(String message);

    /**
     * Sets the transaction identifier, issued by the provider.
     * <p>
     * A transaction can have a single identifier issued by a provider. To avoid duplicates, each payment processor must
     * provide a unique archetype.
     *
     * @param archetype the identifier archetype. Must have an <em>actIdentity.paymentProcessorTransaction</em> prefix.
     * @param id        the transaction identifier
     * @return this
     */
    TransactionUpdater transactionId(String archetype, String id);

    /**
     * Sets the customer url for this transaction.
     *
     * @param url the url
     * @return this
     */
    TransactionUpdater url(String url);

    /**
     * Commits any changes.
     *
     * @return {@code true} if the transaction was updated, {@code false} if no changes were made
     * @throws PaymentProcessorException if the update fails
     */
    boolean update();
}
