/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.paymentprocessor.transaction;

import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.Currency;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.entity.EntityIdentity;
import org.openvpms.component.model.object.Reference;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.practice.Location;
import org.openvpms.paymentprocessor.processor.PaymentProcessor;
import org.openvpms.paymentprocessor.processor.TransactionMode;
import org.openvpms.paymentprocessor.transaction.TransactionUpdater;

public interface Transaction {
    public long getId();

    public TransactionMode getTransactionMode();

    public Reference getParent();

    public String getTransactionId();

    public ActIdentity getTransactionIdentity();

    public OffsetDateTime getDate();

    public Status getStatus();

    public String getMessage();

    public void setStatus(Status var1);

    public void setStatus(Status var1, String var2);

    public Customer getCustomer();

    public String getCustomerId(String var1);

    public EntityIdentity getCustomerIdentity(String var1);

    public PaymentProcessor getPaymentProcessor();

    public Location getLocation();

    public BigDecimal getAmount();

    public String getCurrencyCode();

    public Currency getCurrency();

    public String getEmail();

    public boolean getNotified();

    public String getUrl();

    public TransactionUpdater state();

    public static enum Status {
        PENDING,
        IN_PROGRESS,
        SUBMITTED,
        COMPLETED,
        CANCELLED,
        ERROR;

    }
}

