/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2023 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.paymentprocessor.transaction;

import org.openvpms.domain.query.DomainQuery;
import org.openvpms.paymentprocessor.processor.PaymentProcessor;
import org.openvpms.paymentprocessor.transaction.Transaction.Status;

/**
 * Payment processor transaction query.
 *
 * @author Tim Anderson
 */
public interface AbstractTransactionQuery<T extends Transaction, Q extends AbstractTransactionQuery<T, Q>>
        extends DomainQuery<T, Q> {

    /**
     * Query transactions that have transaction identifiers with the specified archetype.
     *
     * @param archetype the identifier archetype. Must have an <em>actIdentity.paymentProcessorTransaction</em> prefix.
     * @return this
     */
    Q transactionId(String archetype);

    /**
     * Query transactions with the specified transaction identifier.
     *
     * @param archetype the identifier archetype. Must have an <em>actIdentity.paymentProcessorTransaction</em> prefix.
     * @param id        the transaction identifier
     * @return this
     */
    Q transactionId(String archetype, String id);

    /**
     * Query transactions with the specified payment processor.
     *
     * @param processor the payment processor
     * @return this
     */
    Q paymentProcessor(PaymentProcessor processor);

    /**
     * Query transactions with the specified status.
     *
     * @param status the status
     * @return this
     */
    Q status(Status status);
}
