/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2024 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.paymentprocessor.service;

import org.openvpms.paymentprocessor.processor.TransactionMode;

import java.util.Set;

/**
 * Payment processor transaction capabilities.
 *
 * @author Tim Anderson
 */
public interface TransactionCapabilities<T extends TransactionRequirements> {

    /**
     * Returns the transaction modes that this supports.
     *
     * @return the transaction modes
     */
    Set<TransactionMode> getTransactionModes();

    /**
     * Returns the requirements for the specified transaction mode.
     *
     * @param mode the transaction mode
     * @return the requirements, or {@code null} if the mode is unsupported
     */
    T getRequirements(TransactionMode mode);
}