/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.mapping.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.mapping.model.DefaultTarget;
import org.openvpms.mapping.model.Mappings;
import org.openvpms.mapping.model.Target;
import org.openvpms.mapping.model.Targets;

public abstract class AbstractTargets
implements Targets {
    private final String displayName;

    public AbstractTargets(String displayName) {
        this.displayName = displayName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public Target create(String identity, String name, boolean active) {
        return new DefaultTarget(identity, name, active);
    }

    @Override
    public Target getTarget(String identity) {
        Target result = null;
        for (Target target : this.getTargets()) {
            if (!identity.equals(target.getId())) continue;
            result = target;
            break;
        }
        return result;
    }

    @Override
    public List<Target> getTargets(Mappings mappings, String name, boolean unmapped, int firstResult, int maxResults) {
        ArrayList<Target> results = new ArrayList<Target>();
        int matches = 0;
        for (Target target : this.getTargets()) {
            if (!this.matches(target, mappings, name, unmapped)) continue;
            if (matches >= firstResult) {
                results.add(target);
            }
            ++matches;
            if (maxResults == -1 || results.size() != maxResults) continue;
            break;
        }
        return results;
    }

    @Override
    public int count(Mappings mappings, String name, boolean unmapped) {
        int matches = 0;
        for (Target target : this.getTargets()) {
            if (!this.matches(target, mappings, name, unmapped)) continue;
            ++matches;
        }
        return matches;
    }

    protected abstract Collection<Target> getTargets();

    private boolean matches(Target target, Mappings mappings, String name, boolean unmapped) {
        boolean result = false;
        if (!unmapped || mappings.getMapping(target.getId()) == null) {
            String targetName;
            result = name == null ? true : (targetName = target.getName()) != null && StringUtils.containsIgnoreCase((CharSequence)targetName, (CharSequence)name);
        }
        return result;
    }
}

