/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.macro.impl;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Map;
import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.MacroException;
import org.openvpms.macro.impl.Macro;
import org.openvpms.macro.impl.MacroFactory;
import org.openvpms.macro.impl.MacroRunner;

public class MacroContext {
    private final Map<String, Macro> macros;
    private final MacroFactory factory;
    private final Object object;
    private final Variables variables;
    private final FunctionLibrary functions;
    private Deque<String> running = new ArrayDeque<String>();

    public MacroContext(Map<String, Macro> macros, MacroFactory factory, Object object, Variables variables, FunctionLibrary functions) {
        this.macros = macros;
        this.factory = factory;
        this.object = object;
        this.variables = variables;
        this.functions = functions;
    }

    public Object getObject() {
        return this.object;
    }

    public Variables getVariables() {
        return this.variables;
    }

    public FunctionLibrary getFunctions() {
        return this.functions;
    }

    public MacroRunner getRunner(Macro macro) {
        return this.factory.create(macro, this);
    }

    public boolean exists(String macro) {
        return this.macros.containsKey(macro);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String run(Macro macro, String number) {
        String result = null;
        String code = macro.getCode();
        if (this.running.contains(code)) {
            throw new MacroException("Macro " + code + " called recursively from " + StringUtils.join(this.running.descendingIterator(), (String)" => "));
        }
        this.running.push(code);
        try {
            MacroRunner runner = this.getRunner(macro);
            result = runner.run(macro, number);
        }
        finally {
            this.running.pop();
        }
        return result;
    }

    public String run(String macro, String number) {
        String result = null;
        Macro m = this.macros.get(macro);
        if (m != null) {
            result = this.run(m, number);
        }
        return result;
    }
}

