/*
 * Version: 1.0
 *
 * The contents of this file are subject to the OpenVPMS License Version
 * 1.0 (the 'License'); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.openvpms.org/license/
 *
 * Software distributed under the License is distributed on an 'AS IS' basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * Copyright 2019 (C) OpenVPMS Ltd. All Rights Reserved.
 */

package org.openvpms.macro.impl;

import org.openvpms.component.model.lookup.Lookup;


/**
 * A macro definition.
 *
 * @author Tim Anderson
 */
public abstract class Macro {

    /**
     * The macro code.
     */
    private final String code;

    /**
     * The macro name.
     */
    private final String name;

    /**
     * Constructs a {@link Macro} from a lookup.
     *
     * @param lookup the macro lookup
     */
    public Macro(Lookup lookup) {
        this(lookup.getCode(), lookup.getName());
    }

    /**
     * Constructs a {@link Macro}.
     *
     * @param code the macro code
     * @param name the macro name
     */
    public Macro(String code, String name) {
        this.code = code;
        this.name = name;
    }

    /**
     * Returns the macro code.
     *
     * @return the macro code
     */
    public String getCode() {
        return code;
    }

    /**
     * Returns the macro name.
     *
     * @return the macro name
     */
    public String getName() {
        return name;
    }
}
