/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.macro.impl;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.openvpms.archetype.rules.doc.BaseDocumentTemplate;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.macro.MacroException;
import org.openvpms.macro.impl.AbstractExpressionMacroRunner;
import org.openvpms.macro.impl.Macro;
import org.openvpms.macro.impl.MacroContext;
import org.openvpms.macro.impl.ReportMacro;
import org.openvpms.report.IMReport;
import org.openvpms.report.ReportFactory;

public class ReportMacroRunner
extends AbstractExpressionMacroRunner {
    private final ReportFactory factory;
    private static final String ENCODING = "UTF-8";

    public ReportMacroRunner(MacroContext context, ReportFactory factory) {
        super(context);
        this.factory = factory;
    }

    @Override
    public String run(Macro macro, String number) {
        String result;
        ReportMacro reportMacro = (ReportMacro)macro;
        Object object = this.evaluate(reportMacro, number);
        if (object instanceof IMObject) {
            HashMap parameters = new HashMap();
            IMReport report = this.factory.createIMObjectReport((BaseDocumentTemplate)reportMacro.getTemplate());
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            List<IMObject> objects = Collections.singletonList((IMObject)object);
            report.generate(objects, parameters, null, "text/plain", (OutputStream)output);
            try {
                result = new String(output.toByteArray(), ENCODING);
            }
            catch (UnsupportedEncodingException exception) {
                throw new MacroException("Failed to encode report output", exception);
            }
        } else {
            throw new MacroException("Expression='" + reportMacro.getExpression() + "' did not return an object for macro=" + reportMacro.getCode());
        }
        result = result.replaceAll("[\\s&&[^\\n]]+\n", "\n");
        result = result.replaceAll("^\\n+", "");
        result = result.replaceAll("\\n+$", "");
        return result;
    }
}

