/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.macro.impl;

import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.macro.impl.ExpressionMacro;
import org.openvpms.macro.impl.ExpressionMacroRunner;
import org.openvpms.macro.impl.Macro;
import org.openvpms.macro.impl.MacroContext;
import org.openvpms.macro.impl.MacroRunner;
import org.openvpms.macro.impl.ReportMacro;
import org.openvpms.macro.impl.ReportMacroRunner;
import org.openvpms.report.ReportFactory;

public class MacroFactory {
    private final IArchetypeService service;
    private final ReportFactory factory;

    public MacroFactory(IArchetypeService service, ReportFactory factory) {
        this.service = service;
        this.factory = factory;
    }

    public Macro create(Lookup lookup) {
        if (TypeHelper.isA((IMObject)lookup, (String)"lookup.macro")) {
            return new ExpressionMacro(lookup, this.service);
        }
        if (TypeHelper.isA((IMObject)lookup, (String)"lookup.macroReport")) {
            return new ReportMacro(lookup, (ArchetypeService)this.service);
        }
        throw new IllegalArgumentException("Unsupported lookup type: " + lookup.getArchetype());
    }

    public MacroRunner create(Macro macro, MacroContext context) {
        if (macro instanceof ExpressionMacro) {
            return new ExpressionMacroRunner(context);
        }
        if (macro instanceof ReportMacro) {
            return new ReportMacroRunner(context, this.factory);
        }
        throw new IllegalArgumentException("Unsupported macro type: " + macro.getClass().getName());
    }
}

