/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.macro.impl;

import java.util.Collection;
import java.util.Map;
import org.apache.commons.jxpath.FunctionLibrary;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.component.business.service.archetype.AbstractArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.IArchetypeServiceListener;
import org.openvpms.component.business.service.archetype.ReadOnlyArchetypeService;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.impl.AbstractMacros;
import org.openvpms.macro.impl.Macro;
import org.openvpms.macro.impl.MacroArchetypes;
import org.openvpms.macro.impl.MacroContext;
import org.openvpms.macro.impl.MacroFactory;
import org.openvpms.report.ReportFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;

public class LookupMacros
extends AbstractMacros
implements DisposableBean {
    private final IArchetypeService service;
    private final MacroFactory factory;
    private final ArchetypeFunctionsFactory functionsFactory;
    private final IArchetypeServiceListener listener;
    private FunctionLibrary functions;
    private static final Logger log = LoggerFactory.getLogger(LookupMacros.class);

    public LookupMacros(LookupService lookups, IArchetypeService service, ReportFactory factory, ArchetypeFunctionsFactory functions) {
        this.service = service;
        this.factory = new MacroFactory(service, factory);
        this.functionsFactory = functions;
        for (String shortName : MacroArchetypes.LOOKUP_MACROS) {
            this.addMacros(shortName, lookups);
        }
        this.listener = new AbstractArchetypeServiceListener(){

            public void saved(IMObject object) {
                LookupMacros.this.onSaved((Lookup)object);
            }

            public void removed(IMObject object) {
                LookupMacros.this.delete((Lookup)object);
            }
        };
        for (String shortName : MacroArchetypes.LOOKUP_MACROS) {
            service.addListener(shortName, this.listener);
        }
    }

    public void destroy() {
        for (String shortName : MacroArchetypes.LOOKUP_MACROS) {
            this.service.removeListener(shortName, this.listener);
        }
    }

    @Override
    protected MacroContext createMacroContext(Map<String, Macro> macros, Object object, Variables variables) {
        return new MacroContext(macros, this.factory, object, variables, this.getFunctions());
    }

    private synchronized FunctionLibrary getFunctions() {
        if (this.functions == null) {
            this.functions = this.functionsFactory.create((IArchetypeService)new ReadOnlyArchetypeService(this.service), false);
        }
        return this.functions;
    }

    private void addMacros(String shortName, LookupService service) {
        Collection macros = service.getLookups(shortName);
        for (Lookup lookup : macros) {
            if (!lookup.isActive()) continue;
            this.add(lookup);
        }
    }

    private void onSaved(Lookup lookup) {
        if (lookup.isActive()) {
            this.add(lookup);
        } else {
            this.delete(lookup);
        }
    }

    private void add(Lookup lookup) {
        try {
            this.add(this.factory.create(lookup));
        }
        catch (Throwable exception) {
            log.error(exception.getMessage(), exception);
        }
    }

    private void delete(Lookup lookup) {
        this.remove(lookup.getCode());
    }
}

