/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.macro.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.MacroException;
import org.openvpms.macro.Macros;
import org.openvpms.macro.Position;
import org.openvpms.macro.impl.Macro;
import org.openvpms.macro.impl.MacroContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMacros
implements Macros {
    private final Map<String, Macro> macros = Collections.synchronizedMap(new HashMap());
    private final ThreadLocal<ScopedVariables> scopedVariables = new ThreadLocal();
    private static final Logger log = LoggerFactory.getLogger(AbstractMacros.class);

    @Override
    public boolean exists(String macro) {
        return this.macros.containsKey(macro);
    }

    @Override
    public String run(String macro, Object object) {
        return this.run(macro, object, null);
    }

    @Override
    public String run(String macro, Object object, Variables variables) {
        String result = null;
        Token token = Token.parse(macro);
        Macro m = this.macros.get(token.getToken());
        if (m != null) {
            ScopedVariables scoped = this.pushVariables(variables);
            try {
                MacroContext context = this.createMacroContext(this.macros, object, scoped);
                result = context.run(m, token.getNumericPrefix());
            }
            catch (MacroException exception) {
                throw exception;
            }
            catch (Throwable exception) {
                throw new MacroException("Failed to evaluate macro=" + macro, exception);
            }
            finally {
                this.popVariables(variables, scoped);
            }
        }
        return result;
    }

    @Override
    public String runAll(String text, Object object) {
        return this.runAll(text, object, null, null);
    }

    @Override
    public String runAll(String text, Object object, Variables variables, Position position) {
        return this.runAll(text, object, variables, position, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String runAll(String text, Object object, Variables variables, Position position, boolean failOnError) {
        StringBuilder result = new StringBuilder();
        ScopedVariables scoped = this.pushVariables(variables);
        int oldPos = position != null ? position.getOldPosition() : -1;
        int index = 0;
        try {
            MacroContext context = this.createMacroContext(this.macros, object, scoped);
            StringTokenizer tokens = new StringTokenizer(text, " \t\n\r", true);
            while (tokens.hasMoreTokens()) {
                String value;
                Token token = Token.parse(tokens.nextToken());
                Macro macro = this.macros.get(token.getToken());
                int tokenLength = token.getText().length();
                boolean expanded = false;
                if (macro != null) {
                    try {
                        value = context.run(macro, token.getNumericPrefix());
                        expanded = true;
                    }
                    catch (Throwable exception) {
                        if (failOnError) {
                            if (exception instanceof MacroException) {
                                throw exception;
                            }
                            throw new MacroException(exception.getMessage(), exception);
                        }
                        log.warn("Failed to evaluate macro: " + exception.getMessage(), exception);
                        value = token.getText();
                    }
                } else {
                    value = token.getText();
                }
                if (value != null) {
                    result.append(value);
                }
                if (oldPos == -1 || index > oldPos || (index += tokenLength) <= oldPos) continue;
                int newPos = expanded ? result.length() : (result.length() > index ? oldPos + (result.length() - index) : (index > result.length() ? oldPos - (index - result.length()) : oldPos));
                position.setNewPosition(newPos);
                oldPos = -1;
            }
        }
        finally {
            this.popVariables(variables, scoped);
        }
        return result.toString();
    }

    protected void add(Macro macro) {
        this.macros.put(macro.getCode(), macro);
    }

    protected void remove(String code) {
        this.macros.remove(code);
    }

    protected abstract MacroContext createMacroContext(Map<String, Macro> var1, Object var2, Variables var3);

    private ScopedVariables pushVariables(Variables variables) {
        ScopedVariables scoped = this.scopedVariables.get();
        if (scoped == null && variables != null) {
            scoped = new ScopedVariables();
            this.scopedVariables.set(scoped);
        }
        if (scoped != null && variables != null) {
            scoped.push(variables);
        }
        return scoped;
    }

    private void popVariables(Variables variables, ScopedVariables scoped) {
        if (scoped != null && variables != null) {
            scoped.pop();
            if (scoped.isEmpty()) {
                this.scopedVariables.remove();
            }
        }
    }

    private static class Token {
        private final String text;
        private final String numericPrefix;
        private final String token;

        Token(String text, String token, String numericPrefix) {
            this.text = text;
            this.token = token;
            this.numericPrefix = numericPrefix;
        }

        public String getText() {
            return this.text;
        }

        public String getToken() {
            return this.token;
        }

        public String getNumericPrefix() {
            return this.numericPrefix;
        }

        public static Token parse(String text) {
            int index;
            for (index = 0; index < text.length() && Token.isNumeric(text.charAt(index)); ++index) {
            }
            String token = text;
            String numeric = null;
            if (index != 0) {
                numeric = text.substring(0, index);
                token = token.substring(index);
            }
            return new Token(text, token, numeric);
        }

        private static boolean isNumeric(char ch) {
            return Character.isDigit(ch) || ch == '.' || ch == '/';
        }
    }

    private static class ScopedVariables
    implements Variables {
        private final List<Variables> stack = new ArrayList<Variables>();

        private ScopedVariables() {
        }

        public Object get(String name) {
            ListIterator<Variables> iterator = this.stack.listIterator(this.stack.size());
            while (iterator.hasPrevious()) {
                Variables variables = iterator.previous();
                if (!variables.exists(name)) continue;
                return variables.get(name);
            }
            return null;
        }

        public boolean exists(String name) {
            ListIterator<Variables> iterator = this.stack.listIterator(this.stack.size());
            while (iterator.hasPrevious()) {
                Variables variables = iterator.previous();
                if (!variables.exists(name)) continue;
                return true;
            }
            return false;
        }

        public boolean isEmpty() {
            return this.stack.isEmpty();
        }

        void push(Variables variables) {
            this.stack.add(variables);
        }

        void pop() {
            this.stack.remove(this.stack.size() - 1);
        }
    }
}

