/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.macro.impl;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.doc.TestDocumentTemplateBuilder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.business.service.archetype.ReadOnlyArchetypeService;
import org.openvpms.component.business.service.archetype.helper.IMObjectVariables;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.impl.Macro;
import org.openvpms.macro.impl.MacroContext;
import org.openvpms.macro.impl.ReportMacro;
import org.openvpms.macro.impl.ReportMacroRunner;
import org.openvpms.report.ReportFactory;
import org.openvpms.report.ReportFactoryImpl;
import org.openvpms.report.jasper.JRXMLDocumentHandler;
import org.openvpms.report.openoffice.OpenOfficeService;
import org.springframework.beans.factory.annotation.Autowired;

public class ReportMacroRunnerTestCase
extends ArchetypeServiceTest {
    @Autowired
    private OpenOfficeService officeService;
    private DocumentHandlers handlers;
    @Autowired
    private ArchetypeFunctionsFactory functions;
    @Autowired
    private Settings settings;
    private static final String JASPER_REPORT = "/report.jrxml";
    private static final String WORD_REPORT = "/report.doc";
    private static final String OPEN_OFFICE_REPORT = "/report.odt";

    @Before
    public void setUp() {
        IArchetypeService service = this.getArchetypeService();
        this.handlers = new DocumentHandlers((ArchetypeService)service, Collections.singletonList(new JRXMLDocumentHandler((ArchetypeService)service)));
    }

    @Test
    public void testJasperReportMacro() {
        Entity report = this.createReport(JASPER_REPORT);
        String text = this.runMacro(report);
        Assert.assertEquals((Object)"Foo Bar", (Object)text);
    }

    @Test
    public void testWordReport() {
        Entity report = this.createReport(WORD_REPORT);
        String text = this.runMacro(report);
        String expected = "First Name: Foo\nLast Name: Bar";
        text = text.replaceAll("\\s?\\n", "\n");
        text = text.trim();
        Assert.assertEquals((Object)expected, (Object)text);
    }

    @Test
    public void testOpenOfficeReport() {
        Entity report = this.createReport(OPEN_OFFICE_REPORT);
        String text = this.runMacro(report);
        String expected = "First: Foo, Last: Bar";
        text = text.trim();
        Assert.assertEquals((Object)expected, (Object)text);
    }

    private String runMacro(Entity report) {
        Lookup lookup = (Lookup)this.create("lookup.macroReport", Lookup.class);
        IMObjectBean macroBean = this.getBean((IMObject)lookup);
        macroBean.setValue("report", (Object)report.getObjectReference());
        macroBean.setValue("expression", (Object)"$customer");
        IArchetypeService service = this.getArchetypeService();
        Party customer = TestHelper.createCustomer((String)"Foo", (String)"Bar", (boolean)false);
        IMObjectVariables variables = new IMObjectVariables((ArchetypeService)service, this.getLookupService());
        variables.add("customer", (Object)customer);
        ReportMacro macro = new ReportMacro(lookup, (ArchetypeService)service);
        MacroContext context = new MacroContext(Collections.emptyMap(), null, null, (Variables)variables, this.functions.create((IArchetypeService)new ReadOnlyArchetypeService(service), false));
        ReportFactoryImpl factory = new ReportFactoryImpl(service, this.getLookupService(), this.handlers, this.functions, null, null, this.officeService, this.settings);
        ReportMacroRunner runner = new ReportMacroRunner(context, (ReportFactory)factory);
        return runner.run((Macro)macro, "");
    }

    private Entity createReport(String report) {
        TestDocumentTemplateBuilder builder = new TestDocumentTemplateBuilder((ArchetypeService)this.getArchetypeService(), this.handlers);
        return (Entity)((TestDocumentTemplateBuilder)((TestDocumentTemplateBuilder)builder.name(report)).type("REPORT").document(report)).build();
    }
}

