/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.macro.impl;

import org.apache.commons.jxpath.FunctionLibrary;
import org.apache.commons.jxpath.Functions;
import org.apache.commons.jxpath.JXPathContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.archetype.function.factory.DefaultArchetypeFunctionsFactory;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.archetype.rules.contact.BasicAddressFormatter;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.settings.Settings;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.jxpath.JXPathHelper;
import org.openvpms.macro.Macros;
import org.openvpms.macro.impl.LookupMacros;
import org.openvpms.macro.impl.MacroFunctions;
import org.openvpms.macro.impl.MacroTestHelper;
import org.openvpms.report.ReportFactory;
import org.openvpms.report.ReportFactoryImpl;
import org.openvpms.report.openoffice.OpenOfficeService;
import org.springframework.beans.factory.annotation.Autowired;

public class MacroFunctionsTestCase
extends ArchetypeServiceTest {
    @Autowired
    private OpenOfficeService officeService;
    @Autowired
    private Settings settings;
    private LookupMacros macros;
    private ArchetypeFunctionsFactory functions;

    @Before
    public void setUp() {
        MacroTestHelper.createMacro("displayName", "openvpms:get(., 'displayName')");
        MacroTestHelper.createMacro("numbertest", "concat('input number: ', $number)");
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        BasicAddressFormatter formatter = new BasicAddressFormatter((ArchetypeService)service, lookups);
        this.functions = new DefaultArchetypeFunctionsFactory(service, lookups, null, null, (AddressFormatter)formatter, null, null, null, null){

            public FunctionLibrary create(IArchetypeService service, boolean cache) {
                FunctionLibrary library = super.create(service, cache);
                library.addFunctions(this.create("macro", new MacroFunctions((Macros)MacroFunctionsTestCase.this.macros)));
                return library;
            }
        };
        ReportFactoryImpl factory = new ReportFactoryImpl(service, lookups, new DocumentHandlers((ArchetypeService)service), this.functions, null, null, this.officeService, this.settings);
        this.macros = new LookupMacros(lookups, service, (ReportFactory)factory, this.functions);
    }

    @Test
    public void testSingleArgEval() {
        Party customer = TestHelper.createCustomer((boolean)false);
        JXPathContext ctx = this.createContext(customer);
        Assert.assertEquals((Object)"Customer", (Object)ctx.getValue("macro:eval('displayName')"));
    }

    @Test
    public void testTwoArgEval() {
        Party customer = TestHelper.createCustomer((boolean)false);
        JXPathContext ctx = this.createContext(customer);
        Assert.assertEquals((Object)"Customer", (Object)ctx.getValue("macro:eval('displayName', .)"));
        ctx = this.createContext(new Object());
        ctx.getVariables().declareVariable("customer", (Object)customer);
        Assert.assertEquals((Object)"Customer", (Object)ctx.getValue("macro:eval('displayName', $customer)"));
    }

    @Test
    public void testNumericPrefix() {
        Object dummy = new Object();
        JXPathContext ctx = this.createContext(dummy);
        Object text1 = ctx.getValue("macro:eval('numbertest')");
        Assert.assertEquals((Object)"input number: ", (Object)text1);
        Object text2 = ctx.getValue("macro:eval('99numbertest')");
        Assert.assertEquals((Object)"input number: 99", (Object)text2);
    }

    private JXPathContext createContext(Object object) {
        return JXPathHelper.newContext((Object)object, (Functions)this.functions.create());
    }
}

