/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.macro.impl;

import org.apache.commons.jxpath.FunctionLibrary;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.openvpms.archetype.function.factory.ArchetypeFunctionsFactory;
import org.openvpms.archetype.function.factory.DefaultArchetypeFunctionsFactory;
import org.openvpms.archetype.rules.contact.AddressFormatter;
import org.openvpms.archetype.rules.contact.BasicAddressFormatter;
import org.openvpms.archetype.test.ArchetypeServiceTest;
import org.openvpms.archetype.test.TestHelper;
import org.openvpms.archetype.test.builder.customer.TestCustomerFactory;
import org.openvpms.archetype.test.builder.lookup.TestLookupFactory;
import org.openvpms.archetype.test.builder.lookup.TestMacroBuilder;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.lookup.Lookup;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.service.lookup.LookupService;
import org.openvpms.component.system.common.util.Variables;
import org.openvpms.macro.MacroException;
import org.openvpms.macro.Macros;
import org.openvpms.macro.MapVariables;
import org.openvpms.macro.Position;
import org.openvpms.macro.impl.LookupMacros;
import org.openvpms.macro.impl.MacroFunctions;
import org.springframework.beans.factory.annotation.Autowired;

public class LookupMacrosTestCase
extends ArchetypeServiceTest {
    @Autowired
    private TestCustomerFactory customerFactory;
    @Autowired
    private TestLookupFactory lookupFactory;
    private LookupMacros macros;
    private Lookup macro1;
    private Lookup macro2;
    private Party customer;
    private static final String MACRO1_TEXT = "expanded text";

    @Before
    public void setUp() {
        this.customer = (Party)this.customerFactory.newCustomer().build(false);
        this.macro1 = this.createMacro("macro1", "'expanded text'");
        this.macro2 = this.createMacro("@macro2", "concat('one', 'two', 'three')");
        this.createMacro("@empty", "''");
        this.createMacro("displayName", "openvpms:get(., 'displayName')");
        this.createMacro("exceptionMacro", "openvpms:get(., 'invalidnode')");
        this.createMacro("nested", "concat('nested test: ', $macro1)");
        this.createMacro("numbertest", "concat('input number: ', $number)");
        this.createMacro("variableTest", "$variable");
        this.createMacro("recursivemacro1", "$recursivemacro2");
        this.createMacro("recursivemacro2", "$recursivemacro1");
        IArchetypeService service = this.getArchetypeService();
        LookupService lookups = this.getLookupService();
        BasicAddressFormatter formatter = new BasicAddressFormatter((ArchetypeService)service, lookups);
        DefaultArchetypeFunctionsFactory functions = new DefaultArchetypeFunctionsFactory(service, lookups, null, null, (AddressFormatter)formatter, null, null, null, null){

            public FunctionLibrary create(IArchetypeService service, boolean cache) {
                FunctionLibrary library = super.create(service, cache);
                library.addFunctions(this.create("macro", new MacroFunctions((Macros)LookupMacrosTestCase.this.macros)));
                return library;
            }
        };
        this.macros = new LookupMacros(lookups, service, null, (ArchetypeFunctionsFactory)functions);
    }

    @After
    public void tearDown() {
        this.macros.destroy();
    }

    @Test
    public void testRun() {
        String text1 = this.macros.run("macro1", (Object)this.customer);
        Assert.assertEquals((Object)MACRO1_TEXT, (Object)text1);
        String text2 = this.macros.run("@macro2", (Object)this.customer);
        Assert.assertEquals((Object)"onetwothree", (Object)text2);
        String text4 = this.macros.run("displayName", (Object)this.customer);
        Assert.assertEquals((Object)"Customer", (Object)text4);
    }

    @Test(expected=MacroException.class)
    public void testRunException() {
        this.macros.run("exceptionMacro", (Object)this.customer);
    }

    @Test
    public void testRunForNoMacro() {
        Assert.assertNull((Object)this.macros.run("nonExistent", (Object)this.customer));
    }

    @Test
    public void testRunEmbeddedMacro() {
        String text = this.macros.run("nested", new Object());
        Assert.assertEquals((Object)"nested test: expanded text", (Object)text);
    }

    @Test
    public void testRunMacroRecursion() {
        try {
            this.macros.run("recursivemacro1", new Object());
            Assert.fail((String)"Expected MacroException to be thrown");
        }
        catch (MacroException expected) {
            Assert.assertEquals((Object)"Macro recursivemacro1 called recursively from recursivemacro1 => recursivemacro2", (Object)expected.getMessage());
        }
    }

    @Test
    public void testRunNumericPrefix() {
        String text1 = this.macros.run("numbertest", null);
        Assert.assertEquals((Object)"input number: ", (Object)text1);
        String text2 = this.macros.run("99numbertest", null);
        Assert.assertEquals((Object)"input number: 99", (Object)text2);
        String text3 = this.macros.run("0.5numbertest", null);
        Assert.assertEquals((Object)"input number: 0.5", (Object)text3);
        String text4 = this.macros.run("1/2numbertest", null);
        Assert.assertEquals((Object)"input number: 1/2", (Object)text4);
        String text5 = this.macros.run("1/2.0/3numbertest", null);
        Assert.assertEquals((Object)"input number: 1/2.0/3", (Object)text5);
    }

    @Test
    public void testRunDeclareVariable() {
        try {
            this.macros.run("variableTest", null);
            Assert.fail((String)"Expected MacroException to be thrown");
        }
        catch (MacroException macroException) {
            // empty catch block
        }
        MapVariables variables = new MapVariables();
        variables.add("variable", (Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.macros.run("variableTest", null, (Variables)variables));
    }

    @Test
    public void testRunAll() {
        String text = this.macros.runAll("test macro1 @macro2 endtest", (Object)this.customer);
        Assert.assertEquals((Object)"test expanded text onetwothree endtest", (Object)text);
    }

    @Test
    public void testRunAllException() {
        String text1 = this.macros.runAll("exceptionMacro", (Object)this.customer);
        Assert.assertEquals((Object)"exceptionMacro", (Object)text1);
        String text2 = this.macros.runAll("A exceptionMacro B", (Object)this.customer);
        Assert.assertEquals((Object)"A exceptionMacro B", (Object)text2);
    }

    @Test
    public void testRunAllForNoMacro() {
        String text = this.macros.runAll("non existent", new Object());
        Assert.assertEquals((Object)"non existent", (Object)text);
    }

    @Test
    public void testRunAllEmbeddedMacro() {
        String text = this.macros.runAll("nested", null);
        Assert.assertEquals((Object)"nested test: expanded text", (Object)text);
    }

    @Test
    public void testRunAllRecursion() {
        String text1 = this.macros.runAll("recursivemacro1", (Object)this.customer);
        Assert.assertEquals((Object)"recursivemacro1", (Object)text1);
        String text2 = this.macros.runAll("A recursivemacro1 B", (Object)this.customer);
        Assert.assertEquals((Object)"A recursivemacro1 B", (Object)text2);
    }

    @Test
    public void testRunAllMacroRecursion() {
        try {
            this.macros.run("recursivemacro1", new Object());
            Assert.fail((String)"Expected MacroException to be thrown");
        }
        catch (MacroException macroException) {
            // empty catch block
        }
        String result = this.macros.runAll("A recursivemacro1 B", new Object());
        Assert.assertEquals((Object)"A recursivemacro1 B", (Object)result);
    }

    @Test
    public void testRunAllNumericPrefix() {
        String text1 = this.macros.runAll("A numbertest B", null);
        Assert.assertEquals((Object)"A input number:  B", (Object)text1);
        String text2 = this.macros.runAll("A 99numbertest B", null);
        Assert.assertEquals((Object)"A input number: 99 B", (Object)text2);
        String text3 = this.macros.runAll("A 0.5numbertest B", null);
        Assert.assertEquals((Object)"A input number: 0.5 B", (Object)text3);
        String text4 = this.macros.runAll("A 1/2numbertest B", null);
        Assert.assertEquals((Object)"A input number: 1/2 B", (Object)text4);
        String text5 = this.macros.runAll("A 1/2.0/3numbertest B", null);
        Assert.assertEquals((Object)"A input number: 1/2.0/3 B", (Object)text5);
    }

    @Test
    public void testRunAllDeclareVariable() {
        Assert.assertEquals((Object)"variableTest", (Object)this.macros.runAll("variableTest", new Object()));
        MapVariables variables = new MapVariables();
        variables.add("variable", (Object)"foo");
        Assert.assertEquals((Object)"foo", (Object)this.macros.runAll("variableTest", new Object(), (Variables)variables, null));
    }

    @Test
    public void testRunAllCursorPosition() {
        String text = "foo bar";
        this.checkRunAllCursorPosition(text, text, 0, 0);
        this.checkRunAllCursorPosition(text, text, text.length(), text.length());
        this.checkRunAllCursorPosition("macro1", MACRO1_TEXT, 0, MACRO1_TEXT.length());
        this.checkRunAllCursorPosition("macro1", MACRO1_TEXT, 5, MACRO1_TEXT.length());
        this.checkRunAllCursorPosition("a macro1", "a expanded text", 2, 2 + MACRO1_TEXT.length());
        this.checkRunAllCursorPosition("@empty", "", 5, 0);
        this.checkRunAllCursorPosition("x @empty x", "x  x", 1, 1);
        this.checkRunAllCursorPosition("x @empty x", "x  x", 9, 3);
        this.checkRunAllCursorPosition("@empty macro1 x", " expanded text x", 14, 15);
    }

    @Test
    public void testDeactivateMacro() {
        String text = this.macros.run("macro1", (Object)this.customer);
        Assert.assertEquals((Object)MACRO1_TEXT, (Object)text);
        this.macro1.setActive(false);
        this.save((IMObject)this.macro1);
        Assert.assertNull((Object)this.macros.run("macro1", (Object)this.customer));
        Assert.assertEquals((Object)"macro1", (Object)this.macros.runAll("macro1", (Object)this.customer));
    }

    @Test
    public void testDeleteMacro() {
        String text2 = this.macros.run("@macro2", (Object)this.customer);
        Assert.assertEquals((Object)"onetwothree", (Object)text2);
        this.remove((IMObject)this.macro2);
        Assert.assertNull((Object)this.macros.run("@macro2", (Object)this.customer));
        Assert.assertEquals((Object)"@macro2", (Object)this.macros.runAll("@macro2", (Object)this.customer));
    }

    @Test
    public void testMacroCallingMacro() {
        this.createMacro("testDispensingVerb", "'Give'");
        this.createMacro("testDispensingUnits", "'tablet'");
        this.createMacro("@testTwiceADay", "concat($testDispensingVerb, ' ', $number, ' ', $testDispensingUnits, '(s) Twice a Day')");
        String text2 = this.macros.run("3@testTwiceADay", new Object());
        Assert.assertEquals((Object)text2, (Object)"Give 3 tablet(s) Twice a Day");
    }

    @Test
    public void testRunMacroCallingMacroWithVariable() {
        this.createMacro("m_customerId", "openvpms:get($customer, 'id')");
        this.createMacro("@cid", "macro:eval('m_customerId')");
        MapVariables variables = new MapVariables();
        variables.add("customer", (Object)this.customer);
        Assert.assertEquals((Object)"-1", (Object)this.macros.run("@cid", new Object(), (Variables)variables));
        Assert.assertEquals((Object)"-1", (Object)this.macros.runAll("@cid", new Object(), (Variables)variables, null));
    }

    @Test
    public void testRunNumberVariableScoping() {
        this.createMacro("testNumber", "$number");
        this.createMacro("testNestedNumber", "concat($number, macro:eval('2testNumber'))");
        Assert.assertEquals((Object)"3", (Object)this.macros.run("3testNumber", new Object()));
        Assert.assertEquals((Object)"3", (Object)this.macros.runAll("3testNumber", new Object()));
        Assert.assertEquals((Object)"32", (Object)this.macros.run("3testNestedNumber", new Object()));
        Assert.assertEquals((Object)"32", (Object)this.macros.runAll("3testNestedNumber", new Object()));
    }

    @Test
    public void testNewLines() {
        this.createMacro("newlinetest", "concat('a', $nl, 'b')");
        Assert.assertEquals((Object)"a\nb", (Object)this.macros.run("newlinetest", new Object()));
    }

    @Test
    public void testMacrosCantUpdateDatabase() {
        Party patient = TestHelper.createPatient();
        this.createMacro("updatedbtest", "party:setPatientDeceased(.)");
        try {
            this.macros.run("updatedbtest", (Object)patient);
            Assert.fail((String)"Expected macro to fail");
        }
        catch (MacroException macroException) {
            // empty catch block
        }
        patient = (Party)this.get((IMObject)patient);
        IMObjectBean bean = this.getBean((IMObject)patient);
        Assert.assertFalse((boolean)bean.getBoolean("deceased"));
    }

    private Lookup createMacro(String code, String expression) {
        return (Lookup)((TestMacroBuilder)this.lookupFactory.newMacro().code(code)).expression(expression).build();
    }

    private void checkRunAllCursorPosition(String text, String expectedText, int startPosition, int expectedPosition) {
        Position position = new Position(startPosition);
        String expanded = this.macros.runAll(text, (Object)this.customer, null, position);
        Assert.assertEquals((Object)expectedText, (Object)expanded);
        Assert.assertEquals((long)startPosition, (long)position.getOldPosition());
        Assert.assertEquals((long)expectedPosition, (long)position.getNewPosition());
    }
}

