/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.doc.LongTextReader;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.domain.im.act.BeanActDecorator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.laboratory.internal.report.ResultImpl;
import org.openvpms.laboratory.report.Result;
import org.openvpms.laboratory.report.Results;

public class ResultsImpl
implements Results {
    private final DomainService domainService;
    private final BeanActDecorator act;
    private final LongTextReader reader;
    private List<Result> results;
    static final String RESULTS_ID = "resultsId";
    static final String TEST = "test";
    static final String CATEGORY_CODE = "categoryCode";
    static final String CATEGORY_NAME = "categoryName";
    static final String ITEMS = "items";
    static final String NOTES = "notes";
    static final String LONG_NOTES = "longNotes";

    public ResultsImpl(Act act, ArchetypeService service, DomainService domainService) {
        this.act = new BeanActDecorator(act, (IMObjectBeanFactory)domainService);
        this.domainService = domainService;
        this.reader = new LongTextReader(service);
    }

    public ResultsImpl(IMObjectBean bean, ArchetypeService service, DomainService domainService) {
        this.act = new BeanActDecorator(bean);
        this.domainService = domainService;
        this.reader = new LongTextReader(service);
    }

    public String getResultsId() {
        return this.act.getBean().getString(RESULTS_ID);
    }

    public Result.Status getStatus() {
        return ResultImpl.getStatus(this.act.getStatus());
    }

    public OffsetDateTime getDate() {
        return DateRules.toOffsetDateTime((Date)this.act.getActivityStartTime());
    }

    public Test getTest() {
        Entity test = (Entity)this.act.getBean().getTarget(TEST, Entity.class);
        return test != null ? (Test)this.domainService.create((IMObject)test, Test.class) : null;
    }

    public String getCategoryCode() {
        return this.act.getBean().getString(CATEGORY_CODE);
    }

    public String getCategoryName() {
        return this.act.getBean().getString(CATEGORY_NAME);
    }

    public String getNotes() {
        return this.reader.getText((IMObject)this.act, NOTES, LONG_NOTES);
    }

    public List<Result> getResults() {
        if (this.results == null) {
            ArrayList<Result> list = new ArrayList<Result>();
            Comparator<SequencedRelationship> comparator = Comparator.comparingInt(SequencedRelationship::getSequence);
            Policy policy = Policies.all(SequencedRelationship.class, comparator);
            for (Act act : this.act.getBean().getTargets(ITEMS, Act.class, policy)) {
                list.add((Result)this.domainService.create((IMObject)act, Result.class));
            }
            this.results = list;
        }
        return this.results;
    }

    public Act getAct() {
        return this.act;
    }
}

