/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.math.BigDecimal;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.LongTextReader;
import org.openvpms.component.business.domain.im.act.BeanActDecorator;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.IMObjectBeanFactory;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.document.CompressedDocumentImpl;
import org.openvpms.laboratory.report.Result;

public class ResultImpl
implements Result {
    private final BeanActDecorator act;
    private final DocumentHandlers handlers;
    private final LongTextReader reader;
    static final String RESULT_ID = "resultId";
    static final String STATUS = "status";
    static final String ANALYTE_CODE = "analyteCode";
    static final String ANALYTE_NAME = "name";
    static final String RESULT = "result";
    static final String VALUE = "value";
    static final String LONG_RESULT = "longResult";
    static final String UNITS = "units";
    static final String QUALIFIER = "qualifier";
    static final String LOW_RANGE = "lowRange";
    static final String HIGH_RANGE = "highRange";
    static final String EXTREME_LOW_RANGE = "extremeLowRange";
    static final String EXTREME_HIGH_RANGE = "extremeHighRange";
    static final String OUT_OF_RANGE = "outOfRange";
    static final String REFERENCE_RANGE = "referenceRange";
    static final String IMAGE = "image";

    public ResultImpl(Act act, ArchetypeService service, DocumentHandlers handlers) {
        this.act = new BeanActDecorator(act, (IMObjectBeanFactory)service);
        this.handlers = handlers;
        this.reader = new LongTextReader(service);
    }

    ResultImpl(IMObjectBean bean, ArchetypeService service, DocumentHandlers handlers) {
        this.act = new BeanActDecorator(bean);
        this.handlers = handlers;
        this.reader = new LongTextReader(service);
    }

    public String getResultId() {
        return this.act.getBean().getString(RESULT_ID);
    }

    public Result.Status getStatus() {
        return ResultImpl.getStatus(this.act.getStatus());
    }

    public String getAnalyteCode() {
        return this.act.getBean().getString(ANALYTE_CODE);
    }

    public String getAnalyteName() {
        return this.act.getBean().getString(ANALYTE_NAME);
    }

    public BigDecimal getValue() {
        return this.act.getBean().getBigDecimal(VALUE);
    }

    public String getResult() {
        return this.getLongText(RESULT, LONG_RESULT);
    }

    public String getUnits() {
        return this.act.getBean().getString(UNITS);
    }

    public String getQualifier() {
        return this.act.getBean().getString(QUALIFIER);
    }

    public BigDecimal getLowRange() {
        return this.act.getBean().getBigDecimal(LOW_RANGE);
    }

    public BigDecimal getHighRange() {
        return this.act.getBean().getBigDecimal(HIGH_RANGE);
    }

    public BigDecimal getExtremeLowRange() {
        return this.act.getBean().getBigDecimal(EXTREME_LOW_RANGE);
    }

    public BigDecimal getExtremeHighRange() {
        return this.act.getBean().getBigDecimal(EXTREME_HIGH_RANGE);
    }

    public boolean getOutOfRange() {
        return this.act.getBean().getBoolean(OUT_OF_RANGE);
    }

    public String getReferenceRange() {
        return this.act.getBean().getString(REFERENCE_RANGE);
    }

    public String getNotes() {
        return this.getLongText("notes", "longNotes");
    }

    public org.openvpms.component.model.document.Document getImage() {
        Document document;
        CompressedDocumentImpl result = null;
        IMObjectBean bean = this.act.getBean();
        DocumentAct act = (DocumentAct)bean.getTarget(IMAGE, DocumentAct.class);
        if (act != null && act.getDocument() != null && (document = (Document)bean.getObject(act.getDocument(), Document.class)) != null) {
            result = new CompressedDocumentImpl((org.openvpms.component.model.document.Document)document, this.handlers);
        }
        return result;
    }

    public Act getAct() {
        return this.act;
    }

    static Result.Status getStatus(String status) {
        if ("IN_PROGRESS".equals(status)) {
            return Result.Status.IN_PROGRESS;
        }
        if ("COMPLETED".equals(status)) {
            return Result.Status.COMPLETED;
        }
        if ("CANCELLED".equals(status)) {
            return Result.Status.CANCELLED;
        }
        return Result.Status.PENDING;
    }

    private String getLongText(String node, String longNode) {
        return this.reader.getText((IMObject)this.act, node, longNode);
    }
}

