/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.order;

import java.util.EnumSet;
import org.apache.commons.lang.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.laboratory.exception.InvestigationNotFound;
import org.openvpms.laboratory.exception.LaboratoryException;
import org.openvpms.laboratory.internal.i18n.LaboratoryMessages;
import org.openvpms.laboratory.internal.order.AbstractOrderImpl;
import org.openvpms.laboratory.internal.report.ReportBuilderImpl;
import org.openvpms.laboratory.internal.report.ReportImpl;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.report.Report;
import org.openvpms.laboratory.report.ReportBuilder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class OrderImpl
extends AbstractOrderImpl {
    private final PlatformTransactionManager transactionManager;
    private final DocumentHandlers handlers;
    private final DocumentRules rules;
    private static final EnumSet<Order.Status> CANCEL_STATUSES = EnumSet.of(Order.Status.PENDING, Order.Status.SUBMITTING, Order.Status.ERROR, Order.Status.CANCELLED);
    private static final String ORDER_ID = "orderId";
    private static final String TYPE = "type";
    private static final String MESSAGE = "message";

    public OrderImpl(Act order, ArchetypeService service, PatientRules patientRules, DomainService domainService, PlatformTransactionManager transactionManager, DocumentHandlers handlers, DocumentRules rules) {
        super(order, service, patientRules, domainService);
        this.transactionManager = transactionManager;
        this.handlers = handlers;
        this.rules = rules;
    }

    public long getInvestigationId() {
        ActIdentity identity = (ActIdentity)this.bean.getObject("investigationId", ActIdentity.class);
        return identity != null ? Long.parseLong(identity.getIdentity()) : -1L;
    }

    public String getUUID() {
        return this.order.getLinkId();
    }

    public String getOrderId() {
        ActIdentity identity = this.getOrderIdentity();
        return identity != null ? identity.getIdentity() : null;
    }

    public void setOrderId(String archetype, String id) {
        ActIdentity identity = this.getOrderIdentity();
        if (identity == null) {
            identity = (ActIdentity)this.service.create(archetype, ActIdentity.class);
            this.bean.addValue(ORDER_ID, (IMObject)identity);
        } else if (!identity.isA(archetype)) {
            throw new LaboratoryException(LaboratoryMessages.differentOrderIdentifierArchetype(identity.getArchetype(), archetype));
        }
        identity.setIdentity(id);
        this.bean.save();
    }

    public ActIdentity getOrderIdentity() {
        return (ActIdentity)this.bean.getObject(ORDER_ID, ActIdentity.class);
    }

    public void setOrderIdentity(ActIdentity identity) {
        ActIdentity current = this.getOrderIdentity();
        if (current != null) {
            this.bean.removeValue(ORDER_ID, (IMObject)current);
        }
        this.bean.addValue(ORDER_ID, (IMObject)identity);
        this.bean.save();
    }

    public Order.Type getType() {
        return Order.Type.valueOf((String)this.bean.getString(TYPE));
    }

    public Order.Status getStatus() {
        return Order.Status.valueOf((String)this.order.getStatus());
    }

    public void setStatus(Order.Status status) {
        this.setStatus(status, null);
    }

    public void setStatus(Order.Status status, String message) {
        Order.Type type = this.getType();
        if (type == Order.Type.CANCEL && !CANCEL_STATUSES.contains(status)) {
            throw new LaboratoryException(LaboratoryMessages.invalidCancelStatus(status));
        }
        Order.Status existing = this.getStatus();
        if (status != existing) {
            if (existing == Order.Status.ERROR && type != Order.Type.CANCEL) {
                throw new LaboratoryException(LaboratoryMessages.orderWithErrorStatusMustBeCancelled());
            }
            this.order.setStatus(status.name());
            this.setMessage(this.bean, message);
            if (status == Order.Status.CONFIRM && type == Order.Type.NEW) {
                this.setInvestigationOrderStatus("CONFIRM", message);
            }
            if (status == Order.Status.SUBMITTED) {
                if (type == Order.Type.NEW) {
                    this.setInvestigationOrderStatus("SENT", message);
                }
            } else if (status == Order.Status.COMPLETED) {
                if (type == Order.Type.NEW) {
                    this.setInvestigationOrderStatus("RECEIVED", message);
                }
            } else if (status == Order.Status.ERROR) {
                this.setInvestigationOrderStatus("ERROR", message);
            } else if (status == Order.Status.CANCELLED) {
                this.bean.setValue(TYPE, (Object)Order.Type.CANCEL.name());
                this.order.setStatus(Order.Status.CANCELLED.name());
                this.withTransaction(() -> {
                    Act investigation = this.getInvestigation();
                    if (investigation != null && !"CANCELLED".equals(investigation.getStatus())) {
                        investigation.setStatus("CANCELLED");
                        this.setMessage(this.service.getBean((IMObject)investigation), message);
                        this.service.save((IMObject)investigation);
                    }
                    this.bean.save();
                });
            } else {
                this.bean.save();
            }
        }
    }

    public String getMessage() {
        return this.bean.getString(MESSAGE);
    }

    @Override
    public Act getInvestigation() {
        return this.getInvestigation(false);
    }

    public Report getReport() {
        DocumentAct investigation = this.getInvestigation(true);
        return (Report)this.domainService.create((IMObject)investigation, ReportImpl.class);
    }

    public ReportBuilder getReportBuilder() {
        return new ReportBuilderImpl(this.getInvestigation(true), this.order, this.service, this.domainService, this.handlers, this.rules, this.transactionManager);
    }

    private void setInvestigationOrderStatus(String status, String message) {
        this.withTransaction(() -> {
            Act investigation = this.getInvestigation();
            if (investigation != null && !status.equals(investigation.getStatus2()) && !"CANCELLED".equals(investigation.getStatus())) {
                investigation.setStatus2(status);
                this.setMessage(this.service.getBean((IMObject)investigation), message);
                this.service.save((IMObject)investigation);
            }
            this.bean.save();
        });
    }

    private void setMessage(IMObjectBean bean, String message) {
        if (message != null) {
            message = StringUtils.abbreviate((String)message, (int)bean.getMaxLength(MESSAGE));
        }
        bean.setValue(MESSAGE, (Object)message);
    }

    private DocumentAct getInvestigation(boolean fail) {
        DocumentAct result = (DocumentAct)this.bean.getSource("investigation", DocumentAct.class);
        if (result == null && fail) {
            throw new InvestigationNotFound(LaboratoryMessages.investigationNotFound(this.getInvestigationId()));
        }
        return result;
    }

    private void withTransaction(final Runnable runnable) {
        TransactionTemplate template = new TransactionTemplate(this.transactionManager);
        template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

            protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                runnable.run();
            }
        });
    }
}

