/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.io;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptor;
import org.openvpms.component.business.domain.im.archetype.descriptor.ArchetypeDescriptors;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;

class LaboratoryTestIdentityArchetypeFactory {
    private final ArchetypeService service;
    private static final String TEMPLATE = "/org/openvpms/archetype/laboratory/entityIdentity.laboratoryTest.adl";

    public LaboratoryTestIdentityArchetypeFactory(ArchetypeService service) {
        this.service = service;
    }

    public String getArchetype(String laboratory) {
        this.checkLaboratory(laboratory);
        String archetype = this.getTestCodeArchetype(laboratory);
        String match = null;
        for (String existing : this.service.getArchetypes("entityIdentity.laboratoryTest*", false)) {
            if (!existing.equalsIgnoreCase(archetype)) continue;
            match = existing;
            break;
        }
        return match;
    }

    public String create(String laboratory) {
        ArchetypeDescriptors descriptors;
        this.checkLaboratory(laboratory);
        try (InputStream stream = this.getClass().getResourceAsStream(TEMPLATE);){
            if (stream == null) {
                throw new IllegalStateException("Archetype descriptor not found: /org/openvpms/archetype/laboratory/entityIdentity.laboratoryTest.adl");
            }
            descriptors = ArchetypeDescriptors.read((InputStream)stream);
        }
        catch (IOException exception) {
            throw new IllegalStateException("Could not read archetype descriptor: /org/openvpms/archetype/laboratory/entityIdentity.laboratoryTest.adl", exception);
        }
        ArchetypeDescriptor descriptor = (ArchetypeDescriptor)descriptors.getArchetypeDescriptors().get("entityIdentity.laboratoryTest");
        if (descriptor == null) {
            throw new IllegalStateException("entityIdentity.laboratoryTest archetype not found");
        }
        descriptor.setDisplayName(laboratory + " Test Code");
        String archetype = this.getTestCodeArchetype(laboratory);
        descriptor.setName(archetype + ".1.0");
        this.service.save((IMObject)descriptor);
        return archetype;
    }

    private void checkLaboratory(String laboratory) {
        if (!StringUtils.isAlphanumeric((CharSequence)laboratory)) {
            throw new IllegalArgumentException("Argument 'laboratory' must be alphanumeric");
        }
    }

    private String getTestCodeArchetype(String laboratory) {
        return "entityIdentity.laboratoryTest" + laboratory;
    }
}

