/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.builder.EntityBuilder;
import org.openvpms.domain.internal.builder.NodeValue;
import org.openvpms.domain.internal.builder.TargetNodeValue;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.InvestigationType;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.laboratory.service.TestBuilder;
import org.openvpms.laboratory.service.Tests;
import org.springframework.transaction.PlatformTransactionManager;

class TestBuilderImpl
extends EntityBuilder<Test, TestBuilderImpl>
implements TestBuilder {
    private final Tests tests;
    private final TargetNodeValue investigationType = new TargetNodeValue("investigationType");
    private final NodeValue group = new NodeValue("group");
    private final NodeValue useDevice = new NodeValue("useDevice");
    private final NodeValue turnaround = new NodeValue("turnaround");
    private final NodeValue specimen = new NodeValue("specimen");
    private final NodeValue price = new NodeValue("price");

    TestBuilderImpl(Tests tests, ArchetypeService service, PlatformTransactionManager transactionManager, DomainService domainService) {
        super("entity.laboratoryTest", "entityIdentity.laboratoryTest*", Test.class, service, transactionManager, domainService);
        this.tests = tests;
        this.reset();
    }

    public TestBuilder testCode(String archetype, String code) {
        return (TestBuilder)this.entityId(archetype, code);
    }

    public TestBuilder testCodeName(String name) {
        return (TestBuilder)this.entityIdName(name);
    }

    public TestBuilder investigationType(InvestigationType type) {
        return (TestBuilder)this.setValue((NodeValue)this.investigationType, type);
    }

    public TestBuilder group(boolean group) {
        return (TestBuilder)this.setValue(this.group, group);
    }

    public TestBuilder useDevice(Test.UseDevice useDevice) {
        return (TestBuilder)this.setValue(this.useDevice, useDevice != null ? useDevice.toString() : null);
    }

    public TestBuilder turnaround(String notes) {
        return (TestBuilder)this.setValue(this.turnaround, StringUtils.trimToNull((String)notes));
    }

    public TestBuilder specimen(String notes) {
        return (TestBuilder)this.setValue(this.specimen, StringUtils.trimToNull((String)notes));
    }

    public TestBuilder price(BigDecimal price) {
        return (TestBuilder)this.setValue(this.price, price);
    }

    protected Entity getEntity(String archetype, String id) {
        return this.tests.getTest(archetype, id);
    }

    protected boolean populate(Entity test, IMObjectBean bean) {
        boolean changed = super.populate(test, bean);
        return changed |= this.update(bean, new NodeValue[]{this.investigationType, this.group, this.turnaround, this.specimen, this.useDevice, this.price});
    }

    protected void reset() {
        super.reset();
        this.reset(new NodeValue[]{this.group, this.turnaround, this.specimen, this.useDevice, this.price});
    }
}

