/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Selection;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.TypedQuery;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Path;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.component.system.common.query.criteria.TypedQueryIterator;
import org.openvpms.domain.laboratory.Device;
import org.openvpms.domain.laboratory.Laboratory;
import org.openvpms.domain.patient.Patient;
import org.openvpms.laboratory.internal.service.OrderFactory;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.service.OrderQuery;

public class OrderQueryImpl
implements OrderQuery {
    private final ArchetypeService service;
    private final OrderFactory factory;
    private Long investigationId;
    private String orderIdArchetype;
    private String orderId;
    private Reference laboratory;
    private boolean requireDevice;
    private Reference device;
    private String deviceArchetype;
    private Order.Status status;
    private OffsetDateTime createdFrom;
    private OffsetDateTime createdTo;
    private Long patientId;
    private String patientName;
    private boolean patientNameLike;

    public OrderQueryImpl(ArchetypeService service, OrderFactory factory) {
        this.service = service;
        this.factory = factory;
    }

    public OrderQuery investigationId(long id) {
        this.investigationId = id;
        return this;
    }

    public OrderQuery orderId(String archetype, String id) {
        if (!TypeHelper.matches((String)archetype, (String)"actIdentity.laboratoryOrder*")) {
            throw new IllegalStateException("Invalid laboratory order archetype: " + archetype);
        }
        this.orderIdArchetype = archetype;
        this.orderId = id;
        return this;
    }

    public OrderQuery laboratory(Laboratory laboratory) {
        return this.laboratory(laboratory != null ? laboratory.getObjectReference() : null);
    }

    public OrderQuery laboratory(Reference laboratory) {
        this.laboratory = laboratory;
        return this;
    }

    public OrderQuery device(Device device) {
        return this.device(device != null ? device.getObjectReference() : null);
    }

    public OrderQuery device(Reference device) {
        this.device = device;
        return this;
    }

    public OrderQuery requireDevice() {
        return this.requireDevice(null);
    }

    public OrderQuery requireDevice(String archetype) {
        this.requireDevice = true;
        this.deviceArchetype = archetype;
        return this;
    }

    public OrderQuery status(Order.Status status) {
        this.status = status;
        return this;
    }

    public OrderQuery created(OffsetDateTime from, OffsetDateTime to) {
        this.createdFrom = from;
        this.createdTo = to;
        return this;
    }

    public OrderQuery patient(Patient patient) {
        if (patient == null) {
            this.patientId = null;
            return this;
        }
        return this.patient(patient.getId());
    }

    public OrderQuery patient(long id) {
        this.patientId = id;
        return this;
    }

    public OrderQuery patientName(String name, boolean like) {
        this.patientName = name;
        this.patientNameLike = like;
        return this;
    }

    public Iterable<Order> getResults() {
        TypedQuery<Act> query = this.build();
        return () -> new OrderIterator((Iterator<Act>)new TypedQueryIterator(query, 100), this.factory);
    }

    public Order getFirstResult() {
        TypedQuery<Act> query = this.build();
        Act act = (Act)query.getFirstResult();
        return act != null ? this.factory.create(act) : null;
    }

    protected TypedQuery<Act> build() {
        Join idJoin;
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root root = query.from(Act.class, new String[]{"act.laboratoryOrder"}).alias("act");
        query.select((Selection)root);
        if (this.investigationId != null) {
            idJoin = root.join("investigationId").alias("investigationId");
            idJoin.on((Expression)builder.equal((Expression)idJoin.get("identity"), (Object)this.investigationId.toString()));
        }
        if (this.orderId != null) {
            idJoin = root.join("orderId", this.orderIdArchetype).alias("orderId");
            idJoin.on((Expression)builder.equal((Expression)idJoin.get("identity"), (Object)this.orderId));
        }
        if (this.laboratory != null) {
            Join laboratoryJoin = root.join("laboratory");
            laboratoryJoin.on((Expression)builder.equal((Expression)laboratoryJoin.get("entity").alias("laboratory"), (Object)this.laboratory));
        }
        if (this.device != null || this.requireDevice) {
            Join deviceJoin = root.join("device");
            if (this.device != null) {
                deviceJoin.on((Expression)builder.equal((Expression)deviceJoin.get("entity"), (Object)this.device));
            }
            if (this.deviceArchetype != null) {
                deviceJoin.join("entity", this.deviceArchetype).alias("device");
            }
        }
        if (this.patientId != null || this.patientName != null) {
            Join patientJoin = root.join("patient").join("entity").alias("patient");
            if (this.patientId != null) {
                patientJoin.on((Expression)builder.equal((Expression)patientJoin.get("id"), (Object)this.patientId));
            }
            if (this.patientName != null) {
                Path name = patientJoin.get("name");
                if (this.patientNameLike) {
                    patientJoin.on((Expression)builder.like((Expression)name, this.patientName));
                } else {
                    patientJoin.on((Expression)builder.equal((Expression)name, (Object)this.patientName));
                }
            }
        }
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (this.status != null) {
            predicates.add(builder.equal((Expression)root.get("status"), (Object)this.status.toString()));
        }
        if (this.createdFrom != null) {
            predicates.add(builder.greaterThanOrEqualTo((Expression)root.get("startTime"), (Comparable)DateRules.toDate((OffsetDateTime)this.createdFrom)));
        }
        if (this.createdTo != null) {
            predicates.add(builder.lessThan((Expression)root.get("startTime"), (Comparable)DateRules.toDate((OffsetDateTime)this.createdTo)));
        }
        if (!predicates.isEmpty()) {
            query.where(predicates);
        }
        query.orderBy(new javax.persistence.criteria.Order[]{builder.asc((Expression)root.get("id"))});
        return this.service.createQuery(query);
    }

    private static class OrderIterator
    implements Iterator<Order> {
        private Iterator<Act> iterator;
        private OrderFactory factory;

        public OrderIterator(Iterator<Act> iterator, OrderFactory factory) {
            this.iterator = iterator;
            this.factory = factory;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Order next() {
            Act act = this.iterator.next();
            return this.factory.create(act);
        }
    }
}

