/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.laboratory.internal.order.OrderImpl;
import org.openvpms.laboratory.order.Order;
import org.springframework.transaction.PlatformTransactionManager;

class OrderFactory {
    private final ArchetypeService service;
    private final PatientRules patientRules;
    private final DomainService domainService;
    private final PlatformTransactionManager transactionManager;
    private final DocumentHandlers handlers;
    private final DocumentRules documentRules;

    public OrderFactory(ArchetypeService service, PatientRules patientRules, DomainService domainService, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.patientRules = patientRules;
        this.domainService = domainService;
        this.transactionManager = transactionManager;
        this.handlers = new DocumentHandlers(service);
        this.documentRules = new DocumentRules(service);
    }

    public Order create(Act act) {
        return new OrderImpl(act, this.service, this.patientRules, this.domainService, this.transactionManager, this.handlers, this.documentRules);
    }
}

