/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.party.Party;
import org.openvpms.laboratory.exception.LaboratoryException;
import org.openvpms.laboratory.internal.i18n.LaboratoryMessages;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.plugin.manager.PluginManager;

public class LaboratoryServicesImpl
implements LaboratoryServices {
    private final PluginManager manager;
    private final LaboratoryRules rules;

    public LaboratoryServicesImpl(PluginManager manager, LaboratoryRules rules) {
        this.manager = manager;
        this.rules = rules;
    }

    public Entity getLaboratory(Entity investigationType, Party location) {
        return this.rules.getLaboratory(investigationType, location);
    }

    public LaboratoryService getService(Entity investigationType, Party location) {
        Entity config = this.getLaboratory(investigationType, location);
        return config != null ? this.getService(config) : null;
    }

    public LaboratoryService getService(Entity laboratory) {
        LaboratoryService result = null;
        String archetype = laboratory.getArchetype();
        if (laboratory.isA("entity.laboratoryService*")) {
            for (LaboratoryService service : this.manager.getServices(LaboratoryService.class)) {
                if (!archetype.equals(service.getLaboratoryArchetype())) continue;
                result = service;
                break;
            }
        }
        if (result == null) {
            throw new LaboratoryException(LaboratoryMessages.serviceUnavailable(laboratory.getName()));
        }
        return result;
    }
}

