/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.business.service.archetype.rule.IArchetypeRuleService;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Laboratory;
import org.openvpms.laboratory.service.Laboratories;

public class LaboratoriesImpl
implements Laboratories {
    private final IArchetypeRuleService service;
    private final DomainService domainService;

    public LaboratoriesImpl(IArchetypeRuleService service, DomainService domainService) {
        this.service = service;
        this.domainService = domainService;
    }

    public Laboratory getLaboratory(Reference reference) {
        return (Laboratory)this.domainService.get(reference, Laboratory.class);
    }

    public Laboratory getLaboratory(IMObject object) {
        return (Laboratory)this.domainService.create(object, Laboratory.class);
    }

    public List<Laboratory> getLaboratories(String archetype, boolean activeOnly) {
        ArrayList<Laboratory> result = new ArrayList<Laboratory>();
        if (!TypeHelper.matches((String)archetype, (String)"entity.laboratoryService*")) {
            throw new IllegalStateException("Invalid laboratory archetype: " + archetype);
        }
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{archetype});
        if (activeOnly) {
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        }
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        for (Entity entity : this.service.createQuery(query).getResultList()) {
            result.add((Laboratory)this.domainService.create((IMObject)entity, Laboratory.class));
        }
        return result;
    }
}

