/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.InvestigationType;
import org.openvpms.laboratory.internal.service.InvestigationTypeBuilderImpl;
import org.openvpms.laboratory.service.InvestigationTypeBuilder;
import org.openvpms.laboratory.service.InvestigationTypes;
import org.springframework.transaction.PlatformTransactionManager;

public class InvestigationTypesImpl
implements InvestigationTypes {
    private final ArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final DomainService domainService;

    public InvestigationTypesImpl(ArchetypeService service, PlatformTransactionManager transactionManager, DomainService domainService) {
        this.service = service;
        this.transactionManager = transactionManager;
        this.domainService = domainService;
    }

    public InvestigationType getInvestigationType(String archetype, String typeId) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.investigationType"});
        Join identity = root.join("typeId", archetype);
        identity.on((Expression)builder.equal((Expression)identity.get("identity"), (Object)typeId));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        Entity match = (Entity)this.service.createQuery(query).getFirstResult();
        return match != null ? (InvestigationType)this.domainService.create((IMObject)match, InvestigationType.class) : null;
    }

    public List<InvestigationType> getInvestigationTypes(String archetype, boolean activeOnly) {
        ArrayList<InvestigationType> result = new ArrayList<InvestigationType>();
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.investigationType"});
        root.join("typeId", archetype);
        if (activeOnly) {
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        }
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        for (Entity entity : this.service.createQuery(query).getResultList()) {
            result.add((InvestigationType)this.domainService.create((IMObject)entity, InvestigationType.class));
        }
        return result;
    }

    public InvestigationTypeBuilder getInvestigationTypeBuilder() {
        return new InvestigationTypeBuilderImpl(this, this.service, this.transactionManager, this.domainService);
    }
}

