/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Device;
import org.openvpms.laboratory.internal.service.DeviceBuilderImpl;
import org.openvpms.laboratory.service.DeviceBuilder;
import org.openvpms.laboratory.service.Devices;
import org.springframework.transaction.PlatformTransactionManager;

public class DevicesImpl
implements Devices {
    private final ArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final DomainService domainService;

    public DevicesImpl(ArchetypeService service, PlatformTransactionManager transactionManager, DomainService domainService) {
        this.service = service;
        this.transactionManager = transactionManager;
        this.domainService = domainService;
    }

    public Device getDevice(String archetype, String deviceId) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.laboratoryDevice"});
        Join identity = root.join("deviceId", archetype);
        identity.on((Expression)builder.equal((Expression)identity.get("identity"), (Object)deviceId));
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        Entity match = (Entity)this.service.createQuery(query).getFirstResult();
        return match != null ? (Device)this.domainService.create((IMObject)match, Device.class) : null;
    }

    public List<Device> getDevices(String archetype, boolean activeOnly) {
        ArrayList<Device> result = new ArrayList<Device>();
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.laboratoryDevice"});
        root.join("deviceId", archetype);
        if (activeOnly) {
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        }
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        for (Entity entity : this.service.createQuery(query).getResultList()) {
            result.add((Device)this.domainService.create((IMObject)entity, Device.class));
        }
        return result;
    }

    public DeviceBuilder getDeviceBuilder() {
        return new DeviceBuilderImpl(this, this.service, this.transactionManager, this.domainService);
    }
}

