/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.DocumentRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActIdentity;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.patient.record.AbstractDocumentBuilder;
import org.openvpms.laboratory.exception.LaboratoryException;
import org.openvpms.laboratory.internal.i18n.LaboratoryMessages;
import org.openvpms.laboratory.internal.report.Builder;
import org.openvpms.laboratory.internal.report.ReportImpl;
import org.openvpms.laboratory.internal.report.ResultsBuilderImpl;
import org.openvpms.laboratory.internal.report.State;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.report.Report;
import org.openvpms.laboratory.report.ReportBuilder;
import org.openvpms.laboratory.report.ResultsBuilder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionCallbackWithoutResult;
import org.springframework.transaction.support.TransactionTemplate;

public class ReportBuilderImpl
extends Builder<Report>
implements ReportBuilder {
    private final DocumentAct investigation;
    private final Act order;
    private final IMObjectBean bean;
    private final DomainService domainService;
    private final DocumentHandlers handlers;
    private final PlatformTransactionManager transactionManager;
    private final ReportDocumentBuilder documentBuilder;
    private State state;
    private String reportId;
    private String status;
    private String reportIdArchetype;
    private String synchronisationId;
    private String summary;
    private Document document;
    private Boolean checkResults;
    private Boolean externalResults;
    static final String PROTECTED_DOCUMENT = "protectedDocument";
    static final String RESULTS = "results";
    static final String CHECK_RESULTS = "checkResults";
    static final String EXTERNAL_RESULTS = "externalResults";
    static final String SYNCHRONISATION_ID = "synchronisationId";
    static final String SUMMARY = "summary";
    static final String REPORT_ID = "reportId";

    public ReportBuilderImpl(DocumentAct investigation, Act order, ArchetypeService service, DomainService domainService, DocumentHandlers handlers, DocumentRules rules, PlatformTransactionManager transactionManager) {
        super(service, domainService);
        this.investigation = investigation;
        this.order = order;
        this.domainService = domainService;
        this.handlers = handlers;
        this.transactionManager = transactionManager;
        this.documentBuilder = new ReportDocumentBuilder(investigation, service, handlers, rules);
        this.documentBuilder.version(false);
        this.state = new State((Act)investigation, service);
        this.bean = this.getBean((IMObject)investigation);
        this.status = order.getStatus2();
        this.synchronisationId = this.bean.getString(SYNCHRONISATION_ID);
        this.summary = this.bean.getString(SUMMARY);
    }

    public ReportBuilder reportId(String archetype, String id) {
        this.reportIdArchetype = archetype;
        this.reportId = StringUtils.trimToNull((String)id);
        return this;
    }

    public ReportBuilder status(Report.Status status) {
        this.status = status.toString();
        return this;
    }

    public ReportBuilder synchronisationId(String id) {
        this.synchronisationId = StringUtils.trimToNull((String)id);
        return this;
    }

    public ReportBuilder summary(String summary) {
        this.summary = StringUtils.trimToNull((String)summary);
        return this;
    }

    public ReportBuilder version(boolean version) {
        this.documentBuilder.version(version);
        return this;
    }

    public ReportBuilder document(String fileName, String mimeType, InputStream stream) {
        this.document = ((ReportDocumentBuilder)((ReportDocumentBuilder)((ReportDocumentBuilder)this.documentBuilder.fileName(fileName)).mimeType(mimeType)).content(stream)).createDocument();
        return this;
    }

    public ReportBuilder checkResults() {
        return this.checkResults(true);
    }

    public ReportBuilder checkResults(boolean checkResults) {
        this.checkResults = checkResults;
        return this;
    }

    public ReportBuilder externalResults() {
        return this.externalResults(true);
    }

    public ReportBuilder externalResults(boolean externalResults) {
        this.externalResults = externalResults;
        return this;
    }

    public ResultsBuilder results(String id) {
        if ((id = StringUtils.trimToNull((String)id)) == null) {
            throw new IllegalArgumentException("Argument 'id' may not be null or empty");
        }
        return new ResultsBuilderImpl(this, id, this.state, this.getService(), this.handlers);
    }

    @Override
    public Report build() {
        Report report;
        try {
            TransactionTemplate template = new TransactionTemplate(this.transactionManager);
            template.execute((TransactionCallback)new TransactionCallbackWithoutResult(){

                protected void doInTransactionWithoutResult(TransactionStatus transactionStatus) {
                    ReportBuilderImpl.this.doBuild();
                }
            });
            this.reset();
            report = (Report)this.domainService.create((IMObject)this.investigation, ReportImpl.class);
        }
        catch (LaboratoryException exception) {
            throw exception;
        }
        catch (Throwable exception) {
            throw new LaboratoryException(LaboratoryMessages.failedToCreateReport(exception.getMessage()), exception);
        }
        return report;
    }

    private void doBuild() {
        this.bean.setValue("endTime", (Object)new Date());
        if (this.document != null) {
            this.documentBuilder.build(this.document, this.state);
        }
        if (this.reportId != null) {
            this.setIdentity();
        }
        this.bean.setValue(SYNCHRONISATION_ID, (Object)this.synchronisationId);
        this.bean.setValue(SUMMARY, (Object)this.summary);
        if (this.checkResults != null && this.checkResults.booleanValue()) {
            this.bean.setValue(CHECK_RESULTS, (Object)this.checkResults);
        } else {
            this.bean.setValue(CHECK_RESULTS, null);
        }
        if (this.externalResults != null && this.externalResults.booleanValue()) {
            this.bean.setValue(EXTERNAL_RESULTS, (Object)this.externalResults);
        } else {
            this.bean.setValue(EXTERNAL_RESULTS, null);
        }
        int sequence = this.getNextSequence(this.bean.getValues(RESULTS, ActRelationship.class));
        for (Act act : this.state.getNew("act.patientInvestigationResults", Act.class)) {
            ActRelationship relationship = (ActRelationship)this.bean.addTarget(RESULTS, (IMObject)act, "investigation");
            relationship.setSequence(sequence++);
        }
        if (this.status != null && !Objects.equals(this.status, this.order.getStatus2())) {
            this.order.setStatus2(this.status);
            this.state.add((IMObject)this.order);
            if ("PARTIAL_RESULTS".equals(this.status) || "WAITING_FOR_SAMPLE".equals(this.status)) {
                this.investigation.setStatus2(this.status);
            } else if (Report.Status.COMPLETED.toString().equals(this.status)) {
                this.order.setStatus(Order.Status.COMPLETED.toString());
                this.investigation.setStatus2("RECEIVED");
            }
        }
        this.state.add((IMObject)this.investigation);
        this.state.save();
    }

    private void reset() {
        this.reportId = null;
        this.status = null;
        this.synchronisationId = null;
        this.summary = null;
        this.document = null;
        this.checkResults = null;
        this.externalResults = null;
        this.documentBuilder.version(false);
        this.state = new State((Act)this.investigation, this.getService());
    }

    private void setIdentity() {
        ActIdentity identity = (ActIdentity)this.bean.getObject(REPORT_ID, ActIdentity.class);
        if (identity != null) {
            if (!identity.isA(this.reportIdArchetype)) {
                throw new IllegalStateException("Cannot change reportId archetype from " + identity.getArchetype() + " to " + this.reportIdArchetype);
            }
        } else {
            identity = this.create(this.reportIdArchetype, ActIdentity.class);
            this.investigation.addIdentity(identity);
        }
        identity.setIdentity(this.reportId);
    }

    private static class ReportDocumentBuilder
    extends AbstractDocumentBuilder<ReportDocumentBuilder> {
        public ReportDocumentBuilder(DocumentAct investigation, ArchetypeService service, DocumentHandlers handlers, DocumentRules rules) {
            super(investigation, service, handlers, rules);
        }

        protected Document createDocument() {
            return super.createDocument();
        }

        public Document build() {
            throw new UnsupportedOperationException();
        }

        public void build(Document document, State state) {
            ArrayList toSave = new ArrayList();
            ArrayList toRemove = new ArrayList();
            this.doBuild(document, toSave, toRemove);
            state.add(toSave);
            state.remove(toRemove);
        }
    }
}

