/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.util.List;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.laboratory.internal.report.LongText;

abstract class Builder<R> {
    protected static final String PARENT = "parent";
    private final Builder<?> parent;
    private final ArchetypeService service;
    private final DomainService domainService;

    Builder(Builder<?> parent) {
        this.parent = parent;
        this.service = parent.service;
        this.domainService = parent.domainService;
    }

    Builder(ArchetypeService service, DomainService domainService) {
        this.parent = null;
        this.service = service;
        this.domainService = domainService;
    }

    public abstract R build();

    protected LongText createLongNotes(IMObjectBean bean) {
        return new LongText(bean, "notes", "longNotes", "act.patientInvestigationResultNote", PARENT, "Long Notes", this.getService());
    }

    <O extends IMObject> O create(String archetype, Class<O> type) {
        return (O)this.service.create(archetype, type);
    }

    IMObjectBean getBean(IMObject object) {
        return this.service.getBean(object);
    }

    Builder<?> getParent() {
        return this.parent;
    }

    ArchetypeService getService() {
        return this.service;
    }

    DomainService getDomainService() {
        return this.domainService;
    }

    int getNextSequence(List<ActRelationship> relationships) {
        int sequence = 0;
        for (ActRelationship relationship : relationships) {
            if (relationship.getSequence() < sequence) continue;
            sequence = relationship.getSequence() + 1;
        }
        return sequence;
    }
}

