/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.io;

import java.util.ArrayList;
import java.util.Collections;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.laboratory.InvestigationType;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.domain.service.object.DomainObjectService;
import org.openvpms.laboratory.internal.io.LaboratoryTestData;
import org.openvpms.laboratory.internal.io.LaboratoryTestDataSet;
import org.openvpms.laboratory.internal.io.LaboratoryTestIdentityArchetypeFactory;
import org.openvpms.laboratory.service.Tests;

public class LaboratoryTestDataUpdater {
    private final Tests tests;
    private final DomainObjectService domainService;
    private final LaboratoryTestIdentityArchetypeFactory factory;

    public LaboratoryTestDataUpdater(Tests tests, DomainObjectService domainService, ArchetypeService service) {
        this.tests = tests;
        this.domainService = domainService;
        this.factory = new LaboratoryTestIdentityArchetypeFactory(service);
    }

    public LaboratoryTestDataSet update(LaboratoryTestDataSet dataSet) {
        ArrayList<LaboratoryTestData> result = new ArrayList<LaboratoryTestData>();
        Entity investigationType = dataSet.getInvestigationType();
        for (LaboratoryTestData data : dataSet.getData()) {
            LaboratoryTestData updated = this.updateTest(data, investigationType);
            result.add(updated);
        }
        return new LaboratoryTestDataSet(result, Collections.emptyList(), investigationType);
    }

    private LaboratoryTestData updateTest(LaboratoryTestData data, Entity defaultInvestigationType) {
        String archetype;
        Entity type = data.getInvestigationType();
        if (type == null) {
            type = defaultInvestigationType;
        }
        if ((archetype = this.factory.getArchetype(data.getLaboratory())) == null) {
            archetype = this.factory.create(data.getLaboratory());
        }
        InvestigationType investigationType = (InvestigationType)this.domainService.create((IMObject)type, InvestigationType.class);
        Test test = this.tests.getTestBuilder().testCode(archetype, data.getCode()).name(data.getName()).description(data.getDescription()).specimen(data.getSpecimen()).turnaround(data.getTurnaround()).investigationType(investigationType).price(data.getNewPrice()).build();
        return new LaboratoryTestData(data, (Entity)test, (Entity)investigationType);
    }
}

