/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.io;

import java.math.BigDecimal;
import org.openvpms.component.model.entity.Entity;

public class LaboratoryTestData {
    private final String laboratory;
    private final String code;
    private final String name;
    private final String description;
    private final String specimen;
    private final String turnaround;
    private final BigDecimal oldPrice;
    private final BigDecimal newPrice;
    private final int line;
    private final Entity test;
    private final Entity investigationType;
    private final String error;

    public LaboratoryTestData(String laboratory, String code, String name, String description, String specimen, String turnaround, BigDecimal oldPrice, BigDecimal newPrice, int line, String error) {
        this.laboratory = laboratory;
        this.code = code;
        this.name = name;
        this.description = description;
        this.specimen = specimen;
        this.turnaround = turnaround;
        this.oldPrice = oldPrice;
        this.newPrice = newPrice;
        this.line = line;
        this.test = null;
        this.investigationType = null;
        this.error = error;
    }

    public LaboratoryTestData(LaboratoryTestData source, Entity test, Entity investigationType) {
        this(source, test, source.getOldPrice(), investigationType);
    }

    public LaboratoryTestData(LaboratoryTestData source, Entity test, BigDecimal oldPrice, Entity investigationType) {
        this(source, oldPrice, test, investigationType, source.getError());
    }

    public LaboratoryTestData(LaboratoryTestData source, String error) {
        this(source, source.getOldPrice(), source.getTest(), source.getInvestigationType(), error);
    }

    private LaboratoryTestData(LaboratoryTestData source, BigDecimal oldPrice, Entity test, Entity investigationType, String error) {
        this.laboratory = source.getLaboratory();
        this.code = source.getCode();
        this.name = source.getName();
        this.description = source.getDescription();
        this.specimen = source.getSpecimen();
        this.turnaround = source.getTurnaround();
        this.oldPrice = oldPrice;
        this.newPrice = source.getNewPrice();
        this.line = source.getLine();
        this.test = test;
        this.investigationType = investigationType;
        this.error = error;
    }

    public String getLaboratory() {
        return this.laboratory;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getSpecimen() {
        return this.specimen;
    }

    public String getTurnaround() {
        return this.turnaround;
    }

    public BigDecimal getOldPrice() {
        return this.oldPrice;
    }

    public BigDecimal getNewPrice() {
        return this.newPrice;
    }

    public int getLine() {
        return this.line;
    }

    public String getError() {
        return this.error;
    }

    public Entity getTest() {
        return this.test;
    }

    public Entity getInvestigationType() {
        return this.investigationType;
    }
}

