/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.dispatcher;

import java.util.Arrays;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Join;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.laboratory.order.Order;

public class OrderService {
    private final ArchetypeService service;
    private final LaboratoryRules rules;

    public OrderService(ArchetypeService service, LaboratoryRules rules) {
        this.service = service;
        this.rules = rules;
    }

    public Act next(Entity laboratory) {
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Act.class);
        Root from = query.from(Act.class, new String[]{"act.laboratoryOrder"});
        Join join = from.join("laboratory");
        join.on((Expression)builder.equal((Expression)join.get("entity"), (Object)laboratory.getObjectReference()));
        query.where((Expression)builder.equal((Expression)from.get("status"), (Object)Order.Status.QUEUED.toString()));
        query.orderBy(new Order[]{builder.asc((Expression)from.get("startTime"))});
        return (Act)this.service.createQuery(query).getFirstResult();
    }

    public Act order(Act investigation) {
        return this.createOrder(investigation, true);
    }

    public Act createOrder(Act investigation, boolean queue) {
        Act order = this.rules.createOrder(investigation);
        if (queue) {
            order.setStatus(Order.Status.QUEUED.toString());
            investigation.setStatus2("SENT");
        } else {
            order.setStatus(Order.Status.PENDING.toString());
            investigation.setStatus2("CONFIRM");
        }
        this.service.save(Arrays.asList(investigation, order));
        return order;
    }

    public boolean cancel(Act order) {
        boolean result = false;
        IMObjectBean bean = this.service.getBean((IMObject)order);
        String type = bean.getString("type");
        if (Order.Type.NEW.name().equals(type)) {
            bean.setValue("type", (Object)Order.Type.CANCEL.name());
            order.setStatus(Order.Status.QUEUED.name());
            this.service.save((IMObject)order);
            result = true;
        } else if (Order.Type.CANCEL.name().equals(type) && Order.Status.PENDING.name().equals(order.getStatus())) {
            order.setStatus(Order.Status.QUEUED.name());
            this.service.save((IMObject)order);
            result = true;
        }
        return result;
    }
}

