/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.builder.EntityBuilder;
import org.openvpms.domain.internal.builder.NodeValue;
import org.openvpms.domain.internal.builder.TargetNodeValue;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Device;
import org.openvpms.domain.laboratory.Laboratory;
import org.openvpms.domain.practice.Location;
import org.openvpms.laboratory.service.DeviceBuilder;
import org.openvpms.laboratory.service.Devices;
import org.springframework.transaction.PlatformTransactionManager;

public class DeviceBuilderImpl
extends EntityBuilder<Device, DeviceBuilderImpl>
implements DeviceBuilder {
    private final Devices devices;
    private final TargetNodeValue laboratory = new TargetNodeValue("laboratory");
    private final Set<Location> addLocations = new LinkedHashSet<Location>();
    private Location[] locations;

    DeviceBuilderImpl(Devices devices, ArchetypeService service, PlatformTransactionManager transactionManager, DomainService domainService) {
        super("entity.laboratoryDevice", "entityIdentity.laboratoryDevice*", Device.class, service, transactionManager, domainService);
        this.devices = devices;
        this.reset();
    }

    public DeviceBuilder deviceId(String archetype, String id) {
        return (DeviceBuilder)this.entityId(archetype, id);
    }

    public DeviceBuilder laboratory(Laboratory laboratory) {
        return (DeviceBuilder)this.setValue((NodeValue)this.laboratory, laboratory);
    }

    public DeviceBuilder locations(Location ... locations) {
        this.locations = locations;
        return this;
    }

    public DeviceBuilder addLocation(Location location) {
        this.addLocations.add(location);
        return this;
    }

    protected Entity getEntity(String archetype, String id) {
        return this.devices.getDevice(archetype, id);
    }

    protected boolean populate(Entity entity, IMObjectBean bean) {
        List existing;
        boolean changed = super.populate(entity, bean);
        changed |= this.update(bean, new NodeValue[]{this.laboratory});
        if (this.locations != null) {
            existing = bean.getTargetRefs("locations");
            for (Location location : this.locations) {
                if (existing.remove(location.getObjectReference())) continue;
                bean.addTarget("locations", (IMObject)location);
                changed = true;
            }
            if (!existing.isEmpty()) {
                for (Reference ref : existing) {
                    bean.removeTarget("locations", ref);
                    changed = true;
                }
            }
        }
        if (!this.addLocations.isEmpty()) {
            existing = bean.getTargetRefs("locations");
            for (Location location : this.addLocations) {
                if (existing.contains(location.getObjectReference())) continue;
                bean.addTarget("locations", (IMObject)location);
                changed = true;
            }
        }
        return changed;
    }

    protected void reset() {
        super.reset();
        this.reset(new NodeValue[]{this.laboratory});
        this.locations = null;
        this.addLocations.clear();
    }
}

