/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;

class State {
    private final Act investigation;
    private final ArchetypeService service;
    private Set<Act> results;
    private final Map<Act, Set<Act>> items = new HashMap<Act, Set<Act>>();
    private final Set<IMObject> toSave = new LinkedHashSet<IMObject>();
    private final Set<Reference> toRemove = new LinkedHashSet<Reference>();

    State(Act investigation, ArchetypeService service) {
        this.investigation = investigation;
        this.service = service;
    }

    public void add(IMObject object) {
        this.toSave.add(object);
    }

    public void add(Collection<? extends IMObject> objects) {
        this.toSave.addAll(objects);
    }

    public void remove(IMObject object) {
        this.remove(object.getObjectReference());
    }

    public void remove(Reference reference) {
        this.toRemove.add(reference);
    }

    public void remove(Collection<? extends Reference> references) {
        this.toRemove.addAll(references);
    }

    public <T> List<T> getNew(String archetype, Class<T> type) {
        ArrayList<T> result = new ArrayList<T>();
        for (IMObject object : this.toSave) {
            if (!object.isNew() || !object.isA(archetype)) continue;
            result.add(type.cast(object));
        }
        return result;
    }

    public Set<Act> getResults() {
        if (this.results == null) {
            this.results = new HashSet<Act>(this.service.getBean((IMObject)this.investigation).getTargets("results", Act.class));
        }
        return this.results;
    }

    public IMObjectBean getResults(String id) {
        for (Act act : this.getResults()) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            if (!id.equals(bean.getString("resultsId"))) continue;
            return bean;
        }
        return null;
    }

    public IMObjectBean getResultItem(Act act, String id) {
        Set<Act> set = this.getResultItems(act);
        for (Act item : set) {
            IMObjectBean bean = this.service.getBean((IMObject)item);
            if (!id.equals(bean.getString("resultId"))) continue;
            return bean;
        }
        return null;
    }

    public Set<Act> getResultItems(Act act) {
        Set<Act> set = this.items.get(act);
        if (set == null) {
            IMObjectBean bean = this.service.getBean((IMObject)act);
            set = new HashSet<Act>(bean.getTargets("items", Act.class));
            this.items.put(act, set);
        }
        return set;
    }

    public void save() {
        this.service.save(this.toSave);
        for (Reference reference : this.toRemove) {
            this.service.remove(reference);
        }
    }
}

