/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.ActRelationship;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.laboratory.exception.LaboratoryException;
import org.openvpms.laboratory.internal.i18n.LaboratoryMessages;
import org.openvpms.laboratory.internal.report.Builder;
import org.openvpms.laboratory.internal.report.LongText;
import org.openvpms.laboratory.internal.report.ReportBuilderImpl;
import org.openvpms.laboratory.internal.report.ResultBuilderImpl;
import org.openvpms.laboratory.internal.report.ResultImpl;
import org.openvpms.laboratory.internal.report.ResultsImpl;
import org.openvpms.laboratory.internal.report.State;
import org.openvpms.laboratory.report.ReportBuilder;
import org.openvpms.laboratory.report.Result;
import org.openvpms.laboratory.report.ResultBuilder;
import org.openvpms.laboratory.report.Results;
import org.openvpms.laboratory.report.ResultsBuilder;

public class ResultsBuilderImpl
extends Builder<Results>
implements ResultsBuilder {
    private final State state;
    private final ArchetypeService service;
    private final DocumentHandlers handlers;
    private final List<Act> pending = new ArrayList<Act>();
    private IMObjectBean bean;
    private String resultsId;
    private Result.Status status;
    private OffsetDateTime date;
    private Reference test;
    private String categoryCode;
    private String categoryName;
    private String notes;
    private LongText longNotes;
    static final String RESULTS = "results";

    ResultsBuilderImpl(ReportBuilderImpl parent, String id, State state, ArchetypeService service, DocumentHandlers handlers) {
        super(parent);
        this.resultsId = id;
        this.state = state;
        this.service = service;
        this.handlers = handlers;
        this.bean = state.getResults(id);
        if (this.bean != null) {
            Act update = (Act)this.bean.getObject(Act.class);
            this.date = DateRules.toOffsetDateTime((Date)update.getActivityStartTime());
            this.test = this.bean.getTargetRef("test");
            this.categoryCode = this.bean.getString("categoryCode");
            this.categoryName = this.bean.getString("categoryName");
            this.longNotes = this.createLongNotes(this.bean);
            this.notes = this.longNotes.getText();
        }
    }

    public ResultsBuilder status(Result.Status status) {
        this.status = status;
        return this;
    }

    public ResultsBuilder date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    public ResultsBuilder test(Test test) {
        this.test = test != null ? test.getObjectReference() : null;
        return this;
    }

    public ResultsBuilder categoryCode(String code) {
        this.categoryCode = StringUtils.trimToNull((String)code);
        return this;
    }

    public ResultsBuilder categoryName(String name) {
        this.categoryName = StringUtils.trimToNull((String)name);
        return this;
    }

    public ResultsBuilder notes(String notes) {
        this.notes = StringUtils.trimToNull((String)notes);
        return this;
    }

    public ResultBuilder result(String id) {
        if ((id = StringUtils.trimToNull((String)id)) == null) {
            throw new IllegalArgumentException("Argument 'id' cannot be null or empty");
        }
        Act results = this.bean != null ? (Act)this.bean.getObject(Act.class) : null;
        return new ResultBuilderImpl(this, id, results, this.state, this.service, this.handlers, this.pending);
    }

    @Override
    public Results build() {
        IMObjectBean bean = this.doBuild();
        return new ResultsImpl(bean, this.service, this.getDomainService());
    }

    public ReportBuilder add() {
        this.doBuild();
        return (ReportBuilder)this.getParent();
    }

    private IMObjectBean doBuild() {
        Act act;
        if (this.resultsId == null) {
            throw new LaboratoryException(LaboratoryMessages.noResultsId());
        }
        if (this.bean == null) {
            act = this.create("act.patientInvestigationResults", Act.class);
            this.bean = this.getBean((IMObject)act);
        } else {
            act = (Act)this.bean.getObject(Act.class);
        }
        act.setActivityEndTime(new Date());
        this.bean.setValue("resultsId", (Object)this.resultsId);
        if (this.date != null) {
            act.setActivityStartTime(DateRules.toDate((OffsetDateTime)this.date));
        }
        if (this.status == null) {
            Set<Act> items = this.state.getResultItems(act);
            items.addAll(this.pending);
            int pending = 0;
            int inprogress = 0;
            int completed = 0;
            for (Act item : items) {
                Result.Status itemStatus = ResultImpl.getStatus(item.getStatus());
                if (itemStatus == Result.Status.PENDING) {
                    ++pending;
                    continue;
                }
                if (itemStatus == Result.Status.IN_PROGRESS) {
                    ++inprogress;
                    continue;
                }
                if (itemStatus != Result.Status.COMPLETED) continue;
                ++completed;
            }
            this.status = pending > 0 ? (pending == items.size() ? Result.Status.PENDING : Result.Status.IN_PROGRESS) : (inprogress > 0 ? Result.Status.IN_PROGRESS : (completed > 0 ? Result.Status.COMPLETED : Result.Status.CANCELLED));
        }
        act.setStatus(this.status.toString());
        if (this.test != null) {
            this.bean.setTarget("test", this.test);
        }
        if (this.categoryCode != null) {
            this.bean.setValue("categoryCode", (Object)this.categoryCode);
        }
        if (this.categoryName != null) {
            this.bean.setValue("categoryName", (Object)this.categoryName);
        }
        if (this.longNotes == null) {
            this.longNotes = this.createLongNotes(this.bean);
        }
        this.longNotes.setText(this.notes, this.state);
        int sequence = this.getNextSequence(this.bean.getValues("items", ActRelationship.class));
        for (Act item : this.pending) {
            if (!item.isA("act.patientInvestigationResultItem") || this.bean.hasTarget("items", (IMObject)item)) continue;
            ActRelationship relationship = (ActRelationship)this.bean.addTarget("items", (IMObject)item, RESULTS);
            relationship.setSequence(sequence++);
        }
        this.state.add((IMObject)act);
        this.state.add(this.pending);
        IMObjectBean result = this.bean;
        this.reset();
        return result;
    }

    private void reset() {
        this.pending.clear();
        this.bean = null;
        this.resultsId = null;
        this.status = null;
        this.date = null;
        this.test = null;
        this.notes = null;
        this.longNotes = null;
    }
}

