/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.openvpms.archetype.rules.doc.LongTextReader;
import org.openvpms.archetype.rules.doc.TextDocumentHandler;
import org.openvpms.component.business.domain.im.document.Document;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.laboratory.internal.report.State;

class LongText {
    private final IMObjectBean bean;
    private final String node;
    private final String longNode;
    private final String archetype;
    private final String targetNode;
    private final String documentName;
    private final ArchetypeService service;
    private DocumentAct act;
    private MutableObject<String> text;

    public LongText(IMObjectBean bean, String node, String longNode, String archetype, String targetNode, String documentName, ArchetypeService service) {
        this.bean = bean;
        this.node = node;
        this.longNode = longNode;
        this.archetype = archetype;
        this.targetNode = targetNode;
        this.documentName = documentName;
        this.service = service;
        this.act = (DocumentAct)bean.getTarget(longNode, DocumentAct.class);
    }

    public String getText() {
        if (this.text == null) {
            String value = this.bean.getString(this.node);
            if (this.act != null) {
                LongTextReader reader = new LongTextReader(this.service);
                value = reader.getText(this.act);
            }
            this.text = new MutableObject((Object)value);
        }
        return (String)this.text.getValue();
    }

    public void setText(String value, State state) {
        String current = this.getText();
        if (!Objects.equals(current, value = StringUtils.trimToNull((String)value))) {
            if (value != null) {
                if (value.length() <= this.bean.getMaxLength(this.node)) {
                    this.bean.setValue(this.node, (Object)value);
                    this.removeLongText(state);
                } else {
                    this.bean.setValue(this.node, null);
                    if (this.act == null) {
                        this.act = (DocumentAct)this.service.create(this.archetype, DocumentAct.class);
                        state.add((IMObject)this.act);
                        this.bean.addTarget(this.longNode, (IMObject)this.act, this.targetNode);
                    }
                    if (this.act.getDocument() != null) {
                        state.remove(this.act.getDocument());
                    }
                    TextDocumentHandler handler = new TextDocumentHandler(this.service);
                    Document document = handler.create(this.documentName, value);
                    this.act.setDocument((Reference)document.getObjectReference());
                    state.add((IMObject)document);
                    state.add((IMObject)this.act);
                }
            } else {
                this.bean.setValue(this.node, null);
                this.removeLongText(state);
            }
            this.text.setValue((Object)value);
        }
    }

    protected void removeLongText(State state) {
        if (this.act != null) {
            this.bean.removeTargets(this.longNode, (IMObject)this.act, this.targetNode);
            Reference document = this.act.getDocument();
            if (document != null) {
                this.act.setDocument(null);
                state.add((IMObject)this.act);
                state.remove(document);
            }
            state.remove((IMObject)this.act);
        }
    }
}

