/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.io;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.archetype.rules.practice.PracticeRules;
import org.openvpms.archetype.rules.product.ProductPriceRules;
import org.openvpms.archetype.rules.product.ProductPriceUpdater;
import org.openvpms.component.business.service.archetype.IArchetypeService;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.model.product.Product;
import org.openvpms.component.model.product.ProductPrice;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.laboratory.internal.io.LaboratoryTestData;
import org.openvpms.laboratory.internal.io.LaboratoryTestDataSet;
import org.openvpms.laboratory.internal.io.LaboratoryTestIdentityArchetypeFactory;
import org.openvpms.laboratory.internal.io.LaboratoryTestProductData;

public class LaboratoryTestDataMatcher {
    private final LaboratoryRules rules;
    private final ProductPriceRules productPriceRules;
    private final PracticeRules practiceRules;
    private final IArchetypeService service;
    private final LaboratoryTestIdentityArchetypeFactory factory;

    public LaboratoryTestDataMatcher(LaboratoryRules rules, ProductPriceRules productPriceRules, PracticeRules practiceRules, IArchetypeService service) {
        this.rules = rules;
        this.productPriceRules = productPriceRules;
        this.practiceRules = practiceRules;
        this.service = service;
        this.factory = new LaboratoryTestIdentityArchetypeFactory((ArchetypeService)service);
    }

    public LaboratoryTestDataSet matchTests(List<LaboratoryTestData> input) {
        ArrayList<LaboratoryTestData> output = new ArrayList<LaboratoryTestData>();
        ArrayList<LaboratoryTestData> errors = new ArrayList<LaboratoryTestData>();
        Entity investigationType = null;
        for (LaboratoryTestData data : input) {
            Entity test = this.getTest(data);
            BigDecimal oldPrice = null;
            boolean valid = false;
            if (test != null) {
                if (test.getName().equalsIgnoreCase(data.getName())) {
                    IMObjectBean bean = this.service.getBean((IMObject)test);
                    Reference ref = bean.getTargetRef("investigationType");
                    if (ref != null) {
                        if (investigationType == null) {
                            investigationType = (Entity)this.service.get(ref, Entity.class);
                        }
                        if (investigationType == null) {
                            errors.add(new LaboratoryTestData(data, "Investigation type not found"));
                        } else if (!ref.equals((Object)investigationType.getObjectReference())) {
                            Entity other = (Entity)this.service.get(ref, Entity.class);
                            String name = other != null ? other.getName() : "not found";
                            errors.add(new LaboratoryTestData(data, "Cannot load to multiple investigation types: " + name));
                        } else {
                            valid = true;
                        }
                    } else {
                        valid = true;
                    }
                    if (valid) {
                        oldPrice = bean.getBigDecimal("price");
                    }
                } else {
                    errors.add(new LaboratoryTestData(data, "The code '" + data.getCode() + "' for test '" + data.getName() + "' matches a different test: '" + test.getName() + "'"));
                }
            } else {
                valid = true;
            }
            if (!valid) continue;
            output.add(new LaboratoryTestData(data, test, oldPrice, investigationType));
        }
        return new LaboratoryTestDataSet(output, errors, investigationType);
    }

    public List<LaboratoryTestProductData> matchProducts(List<LaboratoryTestData> input, Date date) {
        ProductPriceUpdater priceUpdater = new ProductPriceUpdater(this.productPriceRules, this.practiceRules, this.service);
        LinkedHashMap<Product, LaboratoryTestProductData> products = new LinkedHashMap<Product, LaboratoryTestProductData>();
        for (LaboratoryTestData data : input) {
            Entity test = data.getTest();
            if (test == null) continue;
            List matches = this.rules.getProducts(test);
            for (Product product : matches) {
                LaboratoryTestProductData productData;
                if (products.get(product) != null || (productData = this.getProductData(product, priceUpdater, date)) == null) continue;
                products.put(product, productData);
            }
        }
        return new ArrayList<LaboratoryTestProductData>(products.values());
    }

    private Entity getTest(LaboratoryTestData data) {
        Entity test = null;
        String archetype = this.factory.getArchetype(data.getLaboratory());
        if (archetype != null) {
            test = this.rules.getTest(archetype, data.getCode());
        }
        return test;
    }

    private LaboratoryTestProductData getProductData(Product product, ProductPriceUpdater priceUpdater, Date date) {
        Product oldProduct;
        LaboratoryTestProductData result = null;
        IMObjectBean bean = this.service.getBean((IMObject)product);
        List tests = bean.getTargets("tests", Entity.class, Policies.active());
        BigDecimal newCost = this.getCostPrice(tests);
        ProductPrice unitPrice = this.productPriceRules.getProductPrice(product, "productPrice.unitPrice", date, null);
        BigDecimal oldCost = unitPrice != null ? this.productPriceRules.getCostPrice(unitPrice) : BigDecimal.ZERO;
        List prices = priceUpdater.update(product, newCost, false, false);
        if (!prices.isEmpty() && (oldProduct = (Product)this.service.get(product.getObjectReference(), Product.class)) != null) {
            for (ProductPrice price : prices) {
                product.addProductPrice(price);
            }
            result = new LaboratoryTestProductData(oldProduct, oldCost, product, newCost, tests);
        }
        return result;
    }

    private BigDecimal getCostPrice(List<Entity> tests) {
        BigDecimal result = BigDecimal.ZERO;
        for (Entity test : tests) {
            IMObjectBean bean = this.service.getBean((IMObject)test);
            result = result.add(bean.getBigDecimal("price", BigDecimal.ZERO));
        }
        return result;
    }
}

