/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Order;
import org.openvpms.archetype.rules.laboratory.LaboratoryRules;
import org.openvpms.component.business.service.archetype.helper.TypeHelper;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.query.criteria.CriteriaBuilder;
import org.openvpms.component.query.criteria.CriteriaQuery;
import org.openvpms.component.query.criteria.Root;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.laboratory.internal.service.TestBuilderImpl;
import org.openvpms.laboratory.service.TestBuilder;
import org.openvpms.laboratory.service.Tests;
import org.springframework.transaction.PlatformTransactionManager;

public class TestsImpl
implements Tests {
    private final LaboratoryRules rules;
    private final ArchetypeService service;
    private final PlatformTransactionManager transactionManager;
    private final DomainService domainService;

    public TestsImpl(LaboratoryRules rules, ArchetypeService service, PlatformTransactionManager transactionManager, DomainService domainService) {
        this.rules = rules;
        this.service = service;
        this.transactionManager = transactionManager;
        this.domainService = domainService;
    }

    public Test getTest(String archetype, String code) {
        this.checkTestCode(archetype);
        Entity match = this.rules.getTest(archetype, code);
        return match != null ? (Test)this.domainService.create((IMObject)match, Test.class) : null;
    }

    public List<Test> getTests(String archetype, boolean activeOnly) {
        this.checkTestCode(archetype);
        ArrayList<Test> result = new ArrayList<Test>();
        CriteriaBuilder builder = this.service.getCriteriaBuilder();
        CriteriaQuery query = builder.createQuery(Entity.class);
        Root root = query.from(Entity.class, new String[]{"entity.laboratoryTest"});
        root.join("code", archetype);
        if (activeOnly) {
            query.where((Expression)builder.equal((Expression)root.get("active"), (Object)true));
        }
        query.orderBy(new Order[]{builder.asc((Expression)root.get("id"))});
        for (Entity entity : this.service.createQuery(query).getResultList()) {
            result.add((Test)this.domainService.create((IMObject)entity, Test.class));
        }
        return result;
    }

    public TestBuilder getTestBuilder() {
        return new TestBuilderImpl(this, this.service, this.transactionManager, this.domainService);
    }

    private void checkTestCode(String archetype) {
        if (!TypeHelper.matches((String)archetype, (String)"entityIdentity.laboratoryTest*")) {
            throw new IllegalStateException("Invalid laboratory test code archetype: " + archetype);
        }
    }
}

