/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.laboratory.internal.service.OrderFactory;
import org.openvpms.laboratory.internal.service.OrderQueryImpl;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.service.OrderQuery;
import org.openvpms.laboratory.service.Orders;
import org.springframework.transaction.PlatformTransactionManager;

public class OrdersImpl
implements Orders {
    private final ArchetypeService service;
    private final OrderFactory factory;

    public OrdersImpl(ArchetypeService service, PatientRules patientRules, DomainService factory, PlatformTransactionManager transactionManager) {
        this.service = service;
        this.factory = new OrderFactory(service, patientRules, factory, transactionManager);
    }

    public Order getOrder(long id) {
        return this.getQuery().investigationId(id).getFirstResult();
    }

    public Order getOrder(String archetype, String id) {
        return this.getQuery().orderId(archetype, id).getFirstResult();
    }

    public Order getOrder(Act investigation) {
        IMObjectBean bean = this.service.getBean((IMObject)investigation);
        Act order = (Act)bean.getTarget("order", Act.class);
        return order != null ? this.factory.create(order) : null;
    }

    public OrderQuery getQuery() {
        return new OrderQueryImpl(this.service, this.factory);
    }
}

