/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.laboratory.internal.order.ValidationOrderImpl;
import org.openvpms.laboratory.internal.service.OrderValidationService;
import org.openvpms.laboratory.order.Order;
import org.openvpms.laboratory.service.LaboratoryService;
import org.openvpms.laboratory.service.LaboratoryServices;
import org.openvpms.laboratory.service.OrderValidationStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderValidationServiceImpl
implements OrderValidationService {
    private final LaboratoryServices laboratoryServices;
    private final DomainService domainService;
    private static final Logger log = LoggerFactory.getLogger(OrderValidationServiceImpl.class);

    public OrderValidationServiceImpl(LaboratoryServices laboratoryServices, DomainService domainService) {
        this.laboratoryServices = laboratoryServices;
        this.domainService = domainService;
    }

    @Override
    public OrderValidationService.ValidationStatus validate(DocumentAct investigation) {
        OrderValidationService.ValidationStatus status;
        Entity laboratory = this.getLaboratory(investigation);
        if (!"PENDING".equals(investigation.getStatus2())) {
            String name = laboratory != null ? laboratory.getName() : null;
            status = new OrderValidationService.ValidationStatus(name, OrderValidationStatus.error((String)("Cannot submit orders for investigations with " + investigation.getStatus2() + " status")));
        } else {
            status = laboratory != null ? this.validate(investigation, laboratory) : new OrderValidationService.ValidationStatus(null, OrderValidationStatus.valid());
        }
        return status;
    }

    private OrderValidationService.ValidationStatus validate(DocumentAct investigation, Entity laboratory) {
        OrderValidationService.ValidationStatus status;
        LaboratoryService service = null;
        try {
            service = this.getLaboratoryService(laboratory);
            if (service != null) {
                Order order = (Order)this.domainService.create((IMObject)investigation, ValidationOrderImpl.class);
                status = new OrderValidationService.ValidationStatus(this.getName(service, laboratory), service.validate(order));
            } else {
                status = new OrderValidationService.ValidationStatus(laboratory.getName(), OrderValidationStatus.valid());
            }
        }
        catch (Exception exception) {
            log.error("Failed to validate order for investigation={}, laboratory={} ({}): {}", new Object[]{investigation.getId(), laboratory.getName(), laboratory.getId(), exception.getMessage(), exception});
            status = new OrderValidationService.ValidationStatus(this.getName(service, laboratory), OrderValidationStatus.error((String)exception.getMessage()));
        }
        return status;
    }

    private String getName(LaboratoryService service, Entity laboratory) {
        String result = null;
        if (service != null) {
            try {
                result = service.getName();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (result == null) {
            result = laboratory.getName();
        }
        return result;
    }

    private LaboratoryService getLaboratoryService(Entity laboratory) {
        LaboratoryService result = null;
        if (laboratory.isA("entity.laboratoryService*")) {
            result = this.laboratoryServices.getService(laboratory);
        }
        return result;
    }

    private Entity getLaboratory(DocumentAct investigation) {
        IMObjectBean bean = this.domainService.getBean((IMObject)investigation);
        return (Entity)bean.getTarget("laboratory", Entity.class);
    }
}

