/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.service;

import java.util.List;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.builder.EntityBuilder;
import org.openvpms.domain.internal.builder.NodeValue;
import org.openvpms.domain.internal.builder.TargetNodeValue;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.laboratory.Device;
import org.openvpms.domain.laboratory.InvestigationType;
import org.openvpms.domain.laboratory.Laboratory;
import org.openvpms.laboratory.service.InvestigationTypeBuilder;
import org.openvpms.laboratory.service.InvestigationTypes;
import org.springframework.transaction.PlatformTransactionManager;

public class InvestigationTypeBuilderImpl
extends EntityBuilder<InvestigationType, InvestigationTypeBuilderImpl>
implements InvestigationTypeBuilder {
    private final InvestigationTypes types;
    private final TargetNodeValue laboratory = new TargetNodeValue("laboratory");
    private List<Device> devices;

    InvestigationTypeBuilderImpl(InvestigationTypes types, ArchetypeService service, PlatformTransactionManager transactionManager, DomainService domainService) {
        super("entity.investigationType", "entityIdentity.investigationType*", InvestigationType.class, service, transactionManager, domainService);
        this.types = types;
        this.reset();
    }

    public InvestigationTypeBuilder typeId(String archetype, String id) {
        return (InvestigationTypeBuilder)this.entityId(archetype, id);
    }

    public InvestigationTypeBuilder typeId(String archetype, String id, String name) {
        return (InvestigationTypeBuilder)this.entityId(archetype, id, name);
    }

    public InvestigationTypeBuilder laboratory(Laboratory laboratory) {
        return (InvestigationTypeBuilder)this.setValue((NodeValue)this.laboratory, laboratory);
    }

    public InvestigationTypeBuilder devices(List<Device> devices) {
        this.devices = devices;
        return this;
    }

    protected Entity getEntity(String archetype, String id) {
        return this.types.getInvestigationType(archetype, id);
    }

    protected boolean populate(Entity entity, IMObjectBean bean) {
        boolean changed = super.populate(entity, bean);
        changed |= this.update(bean, new NodeValue[]{this.laboratory});
        if (this.devices != null) {
            changed |= this.updateRelationships(bean, "devices", this.devices);
        }
        return changed;
    }

    protected void reset() {
        super.reset();
        this.reset(new NodeValue[]{this.laboratory});
        this.devices = null;
    }
}

