/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.io.InputStream;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.doc.SupportedImageDocumentHandler;
import org.openvpms.component.business.domain.im.act.DocumentAct;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.object.Reference;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.laboratory.exception.LaboratoryException;
import org.openvpms.laboratory.internal.i18n.LaboratoryMessages;
import org.openvpms.laboratory.internal.report.Builder;
import org.openvpms.laboratory.internal.report.LongText;
import org.openvpms.laboratory.internal.report.ResultImpl;
import org.openvpms.laboratory.internal.report.ResultsBuilderImpl;
import org.openvpms.laboratory.internal.report.State;
import org.openvpms.laboratory.report.Result;
import org.openvpms.laboratory.report.ResultBuilder;
import org.openvpms.laboratory.report.ResultsBuilder;

class ResultBuilderImpl
extends Builder<Result>
implements ResultBuilder {
    private final State state;
    private final List<Act> toSave;
    private final ArchetypeService service;
    private final DocumentHandlers handlers;
    private IMObjectBean bean;
    private String resultId;
    private Result.Status status;
    private String analyteCode;
    private String analyteName;
    private BigDecimal value;
    private String textResult;
    private LongText longTextResult;
    private String units;
    private String qualifier;
    private BigDecimal lowRange;
    private BigDecimal highRange;
    private BigDecimal extremeLowRange;
    private BigDecimal extremeHighRange;
    private Boolean outOfRange;
    private String referenceRange;
    private String notes;
    private LongText longNotes;
    private DocumentAct imageAct;
    private Document image;

    ResultBuilderImpl(ResultsBuilderImpl parent, String id, Act results, State state, ArchetypeService service, DocumentHandlers handlers, List<Act> toSave) {
        super(parent);
        this.state = state;
        this.toSave = toSave;
        this.service = service;
        this.handlers = handlers;
        IMObjectBean iMObjectBean = this.bean = results != null ? state.getResultItem(results, id) : null;
        if (this.bean != null) {
            this.extract(this.bean);
        } else {
            this.reset();
            this.resultId = id;
        }
    }

    public ResultBuilder status(Result.Status status) {
        this.status = status;
        return this;
    }

    public ResultBuilder analyteCode(String code) {
        this.analyteCode = StringUtils.trimToNull((String)code);
        return this;
    }

    public ResultBuilder analyteName(String name) {
        this.analyteName = StringUtils.trimToNull((String)name);
        return this;
    }

    public ResultBuilder value(BigDecimal value) {
        this.value = value;
        return this;
    }

    public ResultBuilder result(String result) {
        this.textResult = StringUtils.trimToNull((String)result);
        return this;
    }

    public ResultBuilder units(String units) {
        this.units = StringUtils.trimToNull((String)units);
        return this;
    }

    public ResultBuilder qualifier(String qualifier) {
        this.qualifier = StringUtils.trimToNull((String)qualifier);
        return this;
    }

    public ResultBuilder lowRange(BigDecimal lowRange) {
        this.lowRange = lowRange;
        return this;
    }

    public ResultBuilder highRange(BigDecimal highRange) {
        this.highRange = highRange;
        return this;
    }

    public ResultBuilder extremeLowRange(BigDecimal extremeLowRange) {
        this.extremeLowRange = extremeLowRange;
        return this;
    }

    public ResultBuilder extremeHighRange(BigDecimal extremeHighRange) {
        this.extremeHighRange = extremeHighRange;
        return this;
    }

    public ResultBuilder outOfRange(boolean outOfRange) {
        this.outOfRange = outOfRange;
        return this;
    }

    public ResultBuilder referenceRange(String range) {
        this.referenceRange = StringUtils.trimToNull((String)range);
        return this;
    }

    public ResultBuilder notes(String notes) {
        this.notes = StringUtils.trimToNull((String)notes);
        return this;
    }

    public ResultBuilder image(String fileName, String mimeType, InputStream stream) {
        SupportedImageDocumentHandler handler = new SupportedImageDocumentHandler(this.service);
        if (StringUtils.isEmpty((CharSequence)mimeType) || !handler.canHandle(fileName, mimeType)) {
            throw new LaboratoryException(LaboratoryMessages.unsupportedImage(fileName, mimeType));
        }
        this.image = handler.create(fileName, stream, mimeType, -1);
        return this;
    }

    @Override
    public Result build() {
        return new ResultImpl(this.buildResult(), this.service, this.handlers);
    }

    public ResultsBuilder add() {
        this.buildResult();
        return (ResultsBuilder)this.getParent();
    }

    protected void populate(IMObjectBean bean) {
        bean.setValue("resultId", (Object)this.resultId);
        if (this.status != null) {
            bean.setValue("status", (Object)this.status.toString());
        }
        bean.setValue("analyteCode", (Object)this.analyteCode);
        bean.setValue("name", (Object)this.analyteName);
        bean.setValue("value", (Object)this.value);
        if (this.longTextResult == null) {
            this.longTextResult = this.createLongTextResult(bean);
        }
        if (this.textResult == null && this.value != null) {
            this.textResult = new DecimalFormat("#,###.#####").format(this.value);
        }
        this.longTextResult.setText(this.textResult, this.state);
        bean.setValue("units", (Object)this.units);
        bean.setValue("qualifier", (Object)this.qualifier);
        bean.setValue("lowRange", (Object)this.lowRange);
        bean.setValue("highRange", (Object)this.highRange);
        bean.setValue("extremeLowRange", (Object)this.extremeLowRange);
        bean.setValue("extremeHighRange", (Object)this.extremeHighRange);
        bean.setValue("outOfRange", (Object)this.getOutOfRange());
        bean.setValue("referenceRange", (Object)this.getReferenceRange());
        if (this.longNotes == null) {
            this.longNotes = this.createLongNotes(bean);
        }
        this.longNotes.setText(this.notes, this.state);
        if (this.image != null) {
            if (this.imageAct == null) {
                this.imageAct = this.create("act.patientInvestigationResultImage", DocumentAct.class);
                bean.addTarget("image", (IMObject)this.imageAct, "parent");
            } else if (this.imageAct.getDocument() != null) {
                this.state.remove((Reference)this.imageAct.getDocument());
            }
            this.imageAct.setFileName(this.image.getName());
            this.imageAct.setMimeType(this.image.getMimeType());
            this.imageAct.setDocument(this.image.getObjectReference());
            this.state.add((IMObject)this.image);
            this.state.add((IMObject)this.imageAct);
        }
    }

    private void extract(IMObjectBean bean) {
        this.resultId = bean.getString("resultId");
        this.status = ResultImpl.getStatus(bean.getString("status"));
        this.analyteCode = bean.getString("analyteCode");
        this.analyteName = bean.getString("name");
        this.value = bean.getBigDecimal("value");
        this.longTextResult = this.createLongTextResult(bean);
        this.textResult = this.longTextResult.getText();
        this.units = bean.getString("units");
        this.qualifier = bean.getString("qualifier");
        this.lowRange = bean.getBigDecimal("lowRange");
        this.highRange = bean.getBigDecimal("highRange");
        this.extremeLowRange = bean.getBigDecimal("extremeLowRange");
        this.extremeHighRange = bean.getBigDecimal("extremeHighRange");
        this.outOfRange = (Boolean)bean.getValue("outOfRange");
        this.referenceRange = bean.getString("referenceRange");
        this.longNotes = this.createLongNotes(bean);
        this.notes = this.longNotes.getText();
        this.imageAct = (DocumentAct)bean.getTarget("image", DocumentAct.class);
    }

    private void reset() {
        this.resultId = null;
        this.status = null;
        this.analyteCode = null;
        this.analyteName = null;
        this.value = null;
        this.textResult = null;
        this.longTextResult = null;
        this.units = null;
        this.qualifier = null;
        this.lowRange = null;
        this.highRange = null;
        this.extremeLowRange = null;
        this.extremeHighRange = null;
        this.outOfRange = null;
        this.referenceRange = null;
        this.notes = null;
        this.longNotes = null;
        this.image = null;
        this.imageAct = null;
    }

    private LongText createLongTextResult(IMObjectBean bean) {
        return new LongText(bean, "result", "longResult", "act.patientInvestigationResultText", "parent", "Long Result", this.getService());
    }

    private Boolean getOutOfRange() {
        if (this.outOfRange == null && this.value != null) {
            if (this.extremeLowRange != null && this.extremeHighRange != null) {
                return this.value.compareTo(this.extremeLowRange) < 0 || this.value.compareTo(this.extremeHighRange) > 0;
            }
            if (this.lowRange != null && this.highRange != null) {
                return this.value.compareTo(this.lowRange) < 0 || this.value.compareTo(this.highRange) > 0;
            }
        }
        return this.outOfRange;
    }

    private String getReferenceRange() {
        String result = this.referenceRange;
        if (result == null) {
            if (this.extremeLowRange != null && this.extremeHighRange != null) {
                result = this.getReferenceRange(this.extremeLowRange, this.extremeHighRange);
            } else if (this.lowRange != null && this.highRange != null) {
                result = this.getReferenceRange(this.lowRange, this.highRange);
            }
        }
        return result;
    }

    private String getReferenceRange(BigDecimal low, BigDecimal high) {
        DecimalFormat format = new DecimalFormat("#,###.#####");
        StringBuilder builder = new StringBuilder();
        builder.append(format.format(low)).append(" - ").append(format.format(high));
        if (this.units != null) {
            builder.append(' ').append(this.units);
        }
        return builder.toString();
    }

    private IMObjectBean buildResult() {
        Act act;
        if (this.resultId == null) {
            throw new LaboratoryException(LaboratoryMessages.noResultId());
        }
        if (this.bean == null) {
            act = this.create("act.patientInvestigationResultItem", Act.class);
            this.bean = this.getBean((IMObject)act);
        } else {
            act = (Act)this.bean.getObject(Act.class);
        }
        this.populate(this.bean);
        this.toSave.add(act);
        IMObjectBean result = this.bean;
        this.reset();
        return result;
    }
}

