/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.report;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.component.business.domain.im.act.ActIdentity;
import org.openvpms.component.business.domain.im.act.BeanDocumentActDecorator;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.act.DocumentAct;
import org.openvpms.component.model.bean.Policies;
import org.openvpms.component.model.bean.Policy;
import org.openvpms.component.model.document.Document;
import org.openvpms.component.model.object.SequencedRelationship;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.internal.document.CompressedDocumentImpl;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.laboratory.internal.report.ResultsImpl;
import org.openvpms.laboratory.report.Report;
import org.openvpms.laboratory.report.Results;

public class ReportImpl
implements Report {
    private final BeanDocumentActDecorator act;
    private final ArchetypeService service;
    private final DomainService domainService;
    private final DocumentHandlers handlers;

    public ReportImpl(DocumentAct act, ArchetypeService service, DomainService domainService, DocumentHandlers handlers) {
        if (!act.isA("act.patientInvestigation")) {
            throw new IllegalArgumentException("Invalid argument 'act' of archetype=" + act.getArchetype() + " passed to ReportImpl");
        }
        this.act = new BeanDocumentActDecorator(act, service);
        this.service = service;
        this.domainService = domainService;
        this.handlers = handlers;
    }

    public String getReportId() {
        ActIdentity id = (ActIdentity)this.act.getBean().getObject("reportId", ActIdentity.class);
        return id != null ? id.getIdentity() : null;
    }

    public Report.Status getStatus() {
        return Report.Status.valueOf((String)this.act.getBean().getString("status2"));
    }

    public String getSynchronisationId() {
        return this.act.getBean().getString("synchronisationId");
    }

    public String getSummary() {
        return this.act.getBean().getString("summary");
    }

    public List<Results> getResults() {
        ArrayList<Results> results = new ArrayList<Results>();
        Comparator<SequencedRelationship> comparator = Comparator.comparingInt(SequencedRelationship::getSequence);
        Policy policy = Policies.all(SequencedRelationship.class, comparator);
        for (Act act : this.act.getBean().getTargets("results", Act.class, policy)) {
            results.add(new ResultsImpl(act, this.service, this.domainService));
        }
        return results;
    }

    public Document getDocument() {
        Document document;
        CompressedDocumentImpl result = null;
        Document document2 = document = this.act.getDocument() != null ? (Document)this.service.get(this.act.getDocument(), Document.class) : null;
        if (document != null) {
            result = new CompressedDocumentImpl(document, this.handlers);
        }
        return result;
    }

    public boolean hasExternalResults() {
        return this.act.getBean().getBoolean("externalResults", false);
    }
}

