/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.order;

import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.openvpms.archetype.rules.patient.PatientRules;
import org.openvpms.archetype.rules.util.DateRules;
import org.openvpms.component.model.act.Act;
import org.openvpms.component.model.bean.IMObjectBean;
import org.openvpms.component.model.entity.Entity;
import org.openvpms.component.model.object.IMObject;
import org.openvpms.component.model.party.Party;
import org.openvpms.component.model.user.User;
import org.openvpms.component.service.archetype.ArchetypeService;
import org.openvpms.domain.customer.Customer;
import org.openvpms.domain.internal.factory.DomainService;
import org.openvpms.domain.internal.user.EmployeeImpl;
import org.openvpms.domain.laboratory.Device;
import org.openvpms.domain.laboratory.InvestigationType;
import org.openvpms.domain.laboratory.Laboratory;
import org.openvpms.domain.laboratory.Test;
import org.openvpms.domain.patient.Patient;
import org.openvpms.domain.patient.record.Visit;
import org.openvpms.domain.practice.Location;
import org.openvpms.domain.user.Employee;
import org.openvpms.laboratory.order.Order;

abstract class AbstractOrderImpl
implements Order {
    protected final Act order;
    protected final IMObjectBean bean;
    protected final ArchetypeService service;
    protected final PatientRules patientRules;
    protected final DomainService domainService;
    private InvestigationType investigationType;
    private Device device;
    private Laboratory laboratory;
    private Patient patient;
    private Customer customer;
    private Location location;

    public AbstractOrderImpl(Act order, ArchetypeService service, PatientRules patientRules, DomainService domainService) {
        this.order = order;
        this.service = service;
        this.patientRules = patientRules;
        this.domainService = domainService;
        this.bean = service.getBean((IMObject)order);
    }

    public OffsetDateTime getCreated() {
        return DateRules.toOffsetDateTime((Date)this.order.getActivityStartTime());
    }

    public InvestigationType getInvestigationType() {
        if (this.investigationType == null) {
            this.investigationType = this.getTarget("investigationType", InvestigationType.class, true);
        }
        return this.investigationType;
    }

    public List<Test> getTests() {
        ArrayList<Test> result = new ArrayList<Test>();
        for (Entity entity : this.bean.getTargets("tests", Entity.class)) {
            result.add((Test)this.domainService.create((IMObject)entity, Test.class));
        }
        return result;
    }

    public Device getDevice() {
        IMObject object;
        if (this.device == null && (object = this.bean.getTarget("device")) != null) {
            this.device = (Device)this.domainService.create(object, Device.class);
        }
        return this.device;
    }

    public Laboratory getLaboratory() {
        if (this.laboratory == null) {
            this.laboratory = this.getTarget("laboratory", Laboratory.class, true);
        }
        return this.laboratory;
    }

    public Patient getPatient() {
        if (this.patient == null) {
            this.patient = this.getTarget("patient", Patient.class, true);
        }
        return this.patient;
    }

    public Customer getCustomer() {
        Party owner;
        if (this.customer == null && (owner = this.patientRules.getOwner(this.order)) != null) {
            this.customer = (Customer)this.domainService.create((IMObject)owner, Customer.class);
        }
        return this.customer;
    }

    public Employee getClinician() {
        return (Employee)this.getTarget("clinician", EmployeeImpl.class, false);
    }

    public Location getLocation() {
        if (this.location == null) {
            this.location = this.getTarget("location", Location.class, true);
        }
        return this.location;
    }

    public Visit getVisit() {
        Act act;
        Visit result = null;
        Act investigation = this.getInvestigation();
        if (investigation != null && (act = (Act)this.service.getBean((IMObject)investigation).getSource("event", Act.class)) != null) {
            result = (Visit)this.domainService.create((IMObject)act, Visit.class);
        }
        return result;
    }

    public Employee getUser() {
        User user = (User)this.bean.getObject("createdBy", User.class);
        return user != null ? (Employee)this.domainService.create((IMObject)user, EmployeeImpl.class) : null;
    }

    public abstract Act getInvestigation();

    public String getNotes() {
        return this.bean.getString("description");
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof AbstractOrderImpl) {
            return ((AbstractOrderImpl)obj).order.equals(this.order);
        }
        return false;
    }

    public int hashCode() {
        return this.order.hashCode();
    }

    private <T> T getTarget(String name, Class<T> type, boolean required) {
        Object result = null;
        IMObject object = this.bean.getTarget(name);
        if (object == null) {
            if (required) {
                throw new IllegalStateException("Order has no " + name + ": " + this.order.getId());
            }
        } else {
            result = this.domainService.create(object, type);
        }
        return (T)result;
    }
}

