/*
 * Decompiled with CFR 0.152.
 */
package org.openvpms.laboratory.internal.io;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openvpms.archetype.csv.AbstractCSVReader;
import org.openvpms.archetype.csv.CSVReaderException;
import org.openvpms.archetype.rules.doc.DocumentHandlers;
import org.openvpms.archetype.rules.math.MathRules;
import org.openvpms.component.model.document.Document;
import org.openvpms.laboratory.internal.io.LaboratoryTestData;
import org.openvpms.laboratory.internal.io.LaboratoryTestDataSet;

public class LaboratoryTestCSVReader
extends AbstractCSVReader {
    private static final int LABORATORY = 0;
    private static final int CODE = 1;
    private static final int NAME = 2;
    private static final int DESCRIPTION = 3;
    private static final int SPECIMEN = 4;
    private static final int TURNAROUND_TIME = 5;
    private static final int PRICE = 6;
    private static final String[] HEADER = new String[]{"Laboratory", "Code", "Name", "Description", "Specimen", "Turnaround Time", "Price"};

    public LaboratoryTestCSVReader(DocumentHandlers handlers, char separator) {
        super(handlers, HEADER, separator);
    }

    public LaboratoryTestDataSet read(Document document) {
        List lines = this.readLines(document);
        ArrayList<LaboratoryTestData> data = new ArrayList<LaboratoryTestData>();
        ArrayList<LaboratoryTestData> errors = new ArrayList<LaboratoryTestData>();
        int lineNo = 2;
        String expectedLaboratory = null;
        for (String[] line : lines) {
            expectedLaboratory = this.parse(line, data, errors, expectedLaboratory, lineNo);
            ++lineNo;
        }
        return new LaboratoryTestDataSet(data, errors, null);
    }

    private String parse(String[] line, List<LaboratoryTestData> valid, List<LaboratoryTestData> errors, String expectedLaboratory, int lineNo) {
        String result = expectedLaboratory;
        String laboratory = null;
        String code = null;
        String name = null;
        String description = null;
        String specimen = null;
        String turnaround = null;
        BigDecimal price = null;
        try {
            this.checkFields(line, lineNo);
            laboratory = this.getLaboratory(line, lineNo, expectedLaboratory);
            code = this.getString(line, 1, lineNo, true, AbstractCSVReader.NewlineBehaviour.REPLACE);
            name = this.getString(line, 2, lineNo, true, AbstractCSVReader.NewlineBehaviour.REPLACE);
            description = this.getString(line, 3, lineNo, false, AbstractCSVReader.NewlineBehaviour.REPLACE);
            specimen = this.getString(line, 4, lineNo, false, AbstractCSVReader.NewlineBehaviour.ALLOWED);
            turnaround = this.getString(line, 5, lineNo, false, AbstractCSVReader.NewlineBehaviour.REPLACE);
            price = this.getPrice(line, lineNo);
            result = laboratory;
            LaboratoryTestData data = new LaboratoryTestData(laboratory, code, name, description, specimen, turnaround, null, price, lineNo, null);
            this.checkMaxLength(code, 1, lineNo, 100);
            this.checkMaxLength(name, 2, lineNo, 100);
            this.checkDuplicateCode(data, valid);
            valid.add(data);
        }
        catch (Exception exception) {
            LaboratoryTestData invalid = new LaboratoryTestData(laboratory, code, name, description, specimen, turnaround, null, price, lineNo, exception.getMessage());
            errors.add(invalid);
        }
        return result;
    }

    private void checkDuplicateCode(LaboratoryTestData data, List<LaboratoryTestData> existing) {
        String code = data.getCode();
        for (LaboratoryTestData other : existing) {
            if (!code.equals(other.getCode())) continue;
            throw new CSVReaderException(CSVReaderException.ErrorCode.DuplicateValue, data.getLine(), new Object[]{HEADER[1], other.getLine(), data.getLine()});
        }
    }

    private String getLaboratory(String[] line, int lineNo, String expectedLaboratory) {
        String result = this.getString(line, 0, lineNo, true);
        if (!StringUtils.isAlphanumeric((CharSequence)result)) {
            this.reportInvalid(HEADER[0], result, lineNo);
        }
        if (expectedLaboratory != null && !result.equals(expectedLaboratory)) {
            this.reportInvalid(HEADER[0], result, lineNo);
        }
        return result;
    }

    private BigDecimal getPrice(String[] line, int lineNo) {
        BigDecimal price = this.getDecimal(line, 6, lineNo, true);
        if (!MathRules.isPositive((BigDecimal)price)) {
            this.reportInvalid(HEADER[6], price.toPlainString(), lineNo);
        }
        return price;
    }
}

